/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.genomics.io.WigFileWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class ExtractRegion
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(ExtractRegion.class);
    @Parameter(names={"-i", "--input"}, description="Input file (BigWig/Wig)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-c", "--chr"}, description="Chromosome", required=true)
    public String chr;
    @Parameter(names={"-s", "--start"}, description="Start base pair")
    public int start = -1;
    @Parameter(names={"-e", "--stop"}, description="Stop base pair")
    public int stop = -1;
    @Parameter(names={"--chunk"}, description="Size to chunk each chromosome into when processing (bp)")
    public int chunkSize = 10000000;
    @Parameter(names={"-f", "--fixedstep"}, description="Force fixedStep output")
    public boolean fixedStep = false;
    @Parameter(names={"-o", "--output"}, description="Output file (wig)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        try (WigFileReader reader = WigFileReader.autodetect((Path)this.inputFile);){
            Interval region;
            if (!reader.includes(this.chr)) {
                throw new CommandLineToolException("Wig file does not contain chromosome " + this.chr);
            }
            if (this.start == -1) {
                this.start = reader.getChrStart(this.chr);
            }
            if (this.stop == -1) {
                this.stop = reader.getChrStop(this.chr);
            }
            if (!reader.includes(region = new Interval(this.chr, this.start, this.stop))) {
                int chrStart = reader.getChrStart(this.chr);
                int chrStop = reader.getChrStop(this.chr);
                throw new CommandLineToolException("Wig file does not contain data for region " + region + ". Wig file has data for " + this.chr + ":" + chrStart + "-" + chrStop);
            }
            try (WigFileWriter writer = new WigFileWriter(this.outputFile, reader.getHeader());){
                try {
                    log.debug((Object)("Loading data for region " + region));
                    Contig contig = reader.query(region);
                    log.debug((Object)"Writing data to output file");
                    if (this.fixedStep) {
                        writer.writeFixedStepContig(contig);
                    } else {
                        writer.write(contig);
                    }
                }
                catch (WigFileException e) {
                    throw new CommandLineToolException(e);
                }
            }
        }
    }

    public static void main(String[] args) {
        new ExtractRegion().instanceMain(args);
    }
}

