/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.utils;

import java.util.Arrays;

public class FloatHistogram {
    int[] bins = null;
    int nBins;
    double xLow;
    double xHigh;
    double delBin;
    int overFlows = 0;
    int underFlows = 0;

    public FloatHistogram(int nBins, double xLow, double xHigh) {
        this.nBins = nBins;
        this.xLow = xLow;
        this.xHigh = xHigh;
        this.bins = new int[nBins];
        this.delBin = (xHigh - xLow) / (double)nBins;
        this.reset();
    }

    public void addValue(double data) {
        if (data < this.xLow) {
            ++this.underFlows;
        } else if (data >= this.xHigh) {
            ++this.overFlows;
        } else {
            int bin = (int)((data - this.xLow) / this.delBin);
            if (bin >= 0 && bin < this.nBins) {
                int n = bin;
                this.bins[n] = this.bins[n] + 1;
            }
        }
    }

    public int[] getHistogram() {
        return this.bins;
    }

    public double getBinSize() {
        return this.delBin;
    }

    public void reset() {
        Arrays.fill(this.bins, 0);
        this.underFlows = 0;
        this.overFlows = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + this.xLow + "\t" + this.underFlows + "\n");
        for (int i = 0; i < this.bins.length; ++i) {
            sb.append(this.xLow + (double)i * this.delBin + "\t" + this.bins[i] + "\n");
        }
        sb.append(">" + this.xHigh + "\t" + this.overFlows);
        return sb.toString();
    }
}

