/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Contig;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.apache.log4j.Logger;

public class WigFileWriter
implements Closeable {
    private static final Logger log = Logger.getLogger(WigFileWriter.class);
    private final Path p;
    private final PrintWriter writer;

    public WigFileWriter(Path p, OpenOption ... options) throws IOException {
        this.p = p;
        log.debug((Object)("Initializing Wig file writer " + p));
        this.writer = new PrintWriter(Files.newBufferedWriter(p, Charset.defaultCharset(), options));
    }

    public WigFileWriter(Path p, TrackHeader header) throws IOException {
        this(p, new OpenOption[0]);
        if (header.getType() != TrackHeader.Type.WIGGLE) {
            log.error((Object)("Refusing to write track header with type=" + header.getType().getId() + " to Wig file"));
        } else {
            log.debug((Object)("Writing Wig file header: " + header));
            this.writer.println(header);
        }
    }

    @Override
    public final void close() throws IOException {
        log.debug((Object)("Closing Wig file writer " + this.p));
        this.writer.close();
    }

    public static DecimalFormat newFormatter() {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(8);
        formatter.setGroupingUsed(false);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setInfinity("Inf");
        symbols.setNaN("NaN");
        formatter.setDecimalFormatSymbols(symbols);
        return formatter;
    }

    public final void write(Contig contig) {
        if (contig.coverage() == 0L) {
            log.debug((Object)"Not writing empty contig with no data values");
        } else {
            float sparsity = (float)contig.coverage() / (float)contig.length();
            if ((double)sparsity < 0.55 || contig.getVariableStepSpan() > contig.getMinStep()) {
                this.writeVariableStepContig(contig);
            } else {
                this.writeFixedStepContig(contig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeFixedStepContig(Contig contig) {
        log.debug((Object)("Writing contig: " + contig.getFixedStepHeader()));
        DecimalFormat formatter = WigFileWriter.newFormatter();
        int step = contig.getMinStep();
        PrintWriter printWriter = this.writer;
        synchronized (printWriter) {
            this.writer.println(contig.getFixedStepHeader());
            for (int bp = contig.getFirstBaseWithData(); bp <= contig.high(); bp += step) {
                this.writer.println(formatter.format(contig.get(bp)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeVariableStepContig(Contig contig) {
        log.debug((Object)("Writing contig: " + contig.getVariableStepHeader()));
        DecimalFormat formatter = WigFileWriter.newFormatter();
        int bp = contig.getFirstBaseWithData();
        int span = contig.getVariableStepSpan();
        PrintWriter printWriter = this.writer;
        synchronized (printWriter) {
            this.writer.println(contig.getVariableStepHeader());
            while (bp <= contig.high()) {
                float value = contig.get(bp);
                if (!Float.isNaN(value)) {
                    this.writer.println(bp + "\t" + formatter.format(value));
                    bp += span;
                    continue;
                }
                ++bp;
            }
        }
    }

    public final Path getPath() {
        return this.p;
    }
}

