/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class IntervalFileWriter<T extends Interval>
implements Closeable {
    private static final Logger log = Logger.getLogger(IntervalFileWriter.class);
    private final Path p;
    private final PrintWriter writer;

    public IntervalFileWriter(Path p, OpenOption ... options) throws IOException {
        this.p = p;
        this.writer = new PrintWriter(Files.newBufferedWriter(p, Charset.defaultCharset(), options));
    }

    @Override
    public void close() {
        log.debug((Object)("Closing Interval file writer " + this.p));
        this.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeComment(String line) {
        PrintWriter printWriter = this.writer;
        synchronized (printWriter) {
            this.writer.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(T entry) {
        PrintWriter printWriter = this.writer;
        synchronized (printWriter) {
            this.writer.println(((Interval)entry).toOutput());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void write(String line) {
        PrintWriter printWriter = this.writer;
        synchronized (printWriter) {
            this.writer.println(line);
        }
    }
}

