/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.genomics.io.WigFileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FilterRegions
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(FilterRegions.class);
    @Parameter(names={"-i", "--input"}, description="Input (Big)wig", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true, validateWith=ReadablePathValidator.class)
    public Path lociFile;
    @Parameter(names={"-o", "--output"}, description="Output file (wig)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        try (WigFileReader reader = WigFileReader.autodetect((Path)this.inputFile);
             IntervalFileReader loci = IntervalFileReader.autodetect((Path)this.lociFile);
             WigFileWriter writer = new WigFileWriter(this.outputFile, reader.getHeader());){
            for (String chr : reader.chromosomes()) {
                int bp = reader.getChrStart(chr);
                int stop = reader.getChrStop(chr);
                log.debug((Object)("Processing chromosome " + chr + " region " + bp + "-" + stop));
                while (bp < stop) {
                    int chunkStart = bp;
                    int chunkStop = Math.min(bp + 10000000 - 1, stop);
                    Interval chunk = new Interval(chr, chunkStart, chunkStop);
                    log.debug((Object)("Processing chunk " + chunk));
                    try {
                        Contig contig = reader.query(chunk);
                        Iterator it = loci.query((Interval)contig);
                        int start = contig.getStart();
                        while (it.hasNext()) {
                            Interval exclude = (Interval)it.next();
                            log.debug((Object)("Skipping interval " + exclude));
                            if (exclude.low() - 1 > start) {
                                writer.write(contig.copy(start, exclude.low() - 1));
                            }
                            start = exclude.high() + 1;
                        }
                        if (start <= contig.getStop()) {
                            writer.write(contig.copy(start, contig.getStop()));
                        }
                    }
                    catch (WigFileException e) {
                        throw new CommandLineToolException("Wig file error while processing chunk " + chr + ":" + chunkStart + "-" + chunkStop, e);
                    }
                    bp = chunkStop + 1;
                }
            }
        }
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new FilterRegions().instanceMain(args);
    }
}

