/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.log4j.Logger;

public class PercusDecomposition
extends WigMathTool {
    private static final Logger log = Logger.getLogger(PercusDecomposition.class);
    @Parameter(names={"-d", "--dyads"}, description="Dyad counts file", required=true, validateWith=ReadablePathValidator.class)
    public Path dyadsFile;
    @Parameter(names={"-n", "--size"}, description="Nucleosome size (bp)")
    public int nucleosomeSize = 147;
    private WigFileReader reader;
    int halfNuc = 73;
    float maxOcc = 0.0f;

    @Override
    public void setup() {
        try {
            this.reader = WigFileReader.autodetect((Path)this.dyadsFile);
        }
        catch (IOException e) {
            log.error((Object)"IOError opening Wig file");
            e.printStackTrace();
            throw new CommandLineToolException("IOError opening Wig file");
        }
        this.addInputFile(this.reader);
        this.halfNuc = this.nucleosomeSize / 2;
        log.debug((Object)"Initializing statistics");
        DescriptiveStatistics percusStats = new DescriptiveStatistics();
        percusStats.setWindowSize(this.nucleosomeSize);
        DescriptiveStatistics occupancyStats = new DescriptiveStatistics();
        occupancyStats.setWindowSize(this.nucleosomeSize);
        log.debug((Object)"Computing maximum genome-wide occupancy (normalization factor)");
        for (String chr : this.reader.chromosomes()) {
            occupancyStats.clear();
            int bp = this.reader.getChrStart(chr);
            int stop = this.reader.getChrStop(chr);
            while (bp <= stop) {
                int chunkStart = bp;
                int chunkStop = Math.min(chunkStart + 10000000 - 1, stop);
                try {
                    float[] data = this.reader.query(chr, chunkStart, chunkStop).getValues();
                    for (int i = 0; i < data.length; ++i) {
                        if (Float.isNaN(data[i])) {
                            data[i] = 0.0f;
                        }
                        occupancyStats.addValue((double)data[i]);
                        if (!(occupancyStats.getSum() > (double)this.maxOcc)) continue;
                        this.maxOcc = (float)occupancyStats.getSum();
                    }
                }
                catch (WigFileException | IOException e) {
                    log.error((Object)"Error getting data from input Wig file");
                    e.printStackTrace();
                    throw new CommandLineToolException("Error getting data from input Wig file");
                }
                bp = chunkStop + 1;
            }
        }
        log.debug((Object)("Computed maximum genome-wide occupancy = " + this.maxOcc));
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        DescriptiveStatistics percusStats = new DescriptiveStatistics();
        percusStats.setWindowSize(this.nucleosomeSize);
        DescriptiveStatistics occupancyStats = new DescriptiveStatistics();
        occupancyStats.setWindowSize(this.nucleosomeSize);
        int paddedStart = Math.max(chunk.getStart() - this.nucleosomeSize, this.reader.getChrStart(chunk.getChr()));
        int paddedStop = Math.min(chunk.getStop() + this.nucleosomeSize, this.reader.getChrStop(chunk.getChr()));
        float[] dyads = this.reader.query(chunk.getChr(), paddedStart, paddedStop).getValues();
        for (int i = 0; i < dyads.length; ++i) {
            if (!Float.isNaN(dyads[i])) continue;
            dyads[i] = 0.0f;
        }
        float[] occ = new float[dyads.length];
        int i = 0;
        while (i < dyads.length) {
            occupancyStats.addValue((double)dyads[i]);
            if (i - this.halfNuc >= 0) {
                occ[i - this.halfNuc] = (float)(occupancyStats.getSum() / (double)this.maxOcc);
            }
            int n = i++;
            dyads[n] = dyads[n] / this.maxOcc;
        }
        for (i = this.halfNuc; i < 3 * this.halfNuc; ++i) {
            double summand = Math.log((1.0f - occ[i]) / (1.0f - occ[i] + dyads[i]));
            percusStats.addValue(summand);
        }
        float[] energies = new float[chunk.length()];
        for (int i2 = this.nucleosomeSize; i2 < dyads.length - this.nucleosomeSize; ++i2) {
            double value = Math.log((1.0f - occ[i2] + dyads[i2]) / dyads[i2]);
            double summand = Math.log((1.0f - occ[i2 + this.halfNuc]) / (1.0f - occ[i2 + this.halfNuc] + dyads[i2 + this.halfNuc]));
            percusStats.addValue(summand);
            double summation = percusStats.getSum();
            energies[i2 - this.nucleosomeSize] = (float)(value + summation);
        }
        return energies;
    }

    public static void main(String[] args) {
        new PercusDecomposition().instanceMain(args);
    }
}

