/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.WigMathTool;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class GaussianSmooth
extends WigMathTool {
    private static final Logger log = Logger.getLogger(GaussianSmooth.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-s", "--stdev"}, description="Standard deviation of Gaussian (bp)")
    public int stdev = 20;
    @Parameter(names={"-w", "--window"}, description="Kernel width in (+/-) standard deviations")
    public int windowWidth = 3;
    WigFileReader reader;
    float[] filter;

    @Override
    public void setup() {
        int i;
        try {
            this.reader = WigFileReader.autodetect((Path)this.inputFile);
        }
        catch (IOException e) {
            throw new CommandLineToolException(e);
        }
        this.inputs.add(this.reader);
        log.debug((Object)"Initializing Gaussian filter");
        this.filter = new float[2 * this.windowWidth * this.stdev + 1];
        float sum = 0.0f;
        for (i = 0; i < this.filter.length; ++i) {
            float value;
            float x = i - 3 * this.stdev;
            this.filter[i] = value = (float)Math.exp(-(x * x) / (float)(2 * this.stdev * this.stdev));
            sum += value;
        }
        i = 0;
        while (i < this.filter.length) {
            int n = i++;
            this.filter[n] = this.filter[n] / sum;
        }
    }

    @Override
    public float[] compute(Interval chunk) throws IOException, WigFileException {
        int paddedStart = Math.max(chunk.getStart() - this.windowWidth * this.stdev, this.reader.getChrStart(chunk.getChr()));
        int paddedStop = Math.min(chunk.getStop() + this.windowWidth * this.stdev, this.reader.getChrStop(chunk.getChr()));
        Contig result = this.reader.query(chunk.getChr(), paddedStart, paddedStop);
        float[] data = result.get(chunk.getStart() - this.windowWidth * this.stdev, chunk.getStop() + this.windowWidth * this.stdev);
        float[] smoothed = new float[chunk.length()];
        for (int i = 0; i < smoothed.length; ++i) {
            for (int j = 0; j < this.filter.length; ++j) {
                int n = i;
                smoothed[n] = smoothed[n] + data[i + j] * this.filter[j];
            }
        }
        return smoothed;
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new GaussianSmooth().instanceMain(args);
    }
}

