/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;

public class MergeSamFiles
extends CommandLineProgram {
    private static final Log log = Log.getInstance(MergeSamFiles.class);
    @Usage
    public String USAGE = "Merges multiple SAM/BAM files into one file.\n";
    @Option(shortName="I", doc="SAM or BAM input file", minElements=1)
    public List<File> INPUT = new ArrayList<File>();
    @Option(shortName="O", doc="SAM or BAM file to write merged result to")
    public File OUTPUT;
    @Option(shortName="SO", doc="Sort order of output file", optional=true)
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.coordinate;
    @Option(doc="If true, assume that the input files are in the same sort order as the requested output sort order, even if their headers say otherwise.", shortName="AS")
    public boolean ASSUME_SORTED = false;
    @Option(shortName="MSD", doc="Merge the seqeunce dictionaries", optional=true)
    public boolean MERGE_SEQUENCE_DICTIONARIES = false;
    @Option(doc="Option to create a background thread to encode, compress and write to disk the output file. The threaded version uses about 20% more CPU and decreases runtime by ~20% when writing out a compressed BAM file.")
    public boolean USE_THREADING = false;
    @Option(doc="Comment(s) to include in the merged output file's header.", optional=true, shortName="CO")
    public List<String> COMMENT = new ArrayList<String>();
    private static final int PROGRESS_INTERVAL = 1000000;

    public static void main(String[] argv) {
        System.exit(new MergeSamFiles().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        boolean presorted;
        boolean mergingSamRecordIteratorAssumeSorted;
        SAMFileHeader.SortOrder headerMergerSortOrder;
        boolean matchedSortOrders = true;
        ArrayList<SAMFileReader> readers = new ArrayList<SAMFileReader>();
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>();
        SAMSequenceDictionary dict = null;
        for (File inFile : this.INPUT) {
            IoUtil.assertFileIsReadable(inFile);
            SAMFileReader in = new SAMFileReader(inFile);
            readers.add(in);
            headers.add(in.getFileHeader());
            if (dict == null) {
                dict = in.getFileHeader().getSequenceDictionary();
            } else if (dict.equals((Object)in.getFileHeader().getSequenceDictionary())) {
                in.getFileHeader().setSequenceDictionary(dict);
            }
            matchedSortOrders = matchedSortOrders && in.getFileHeader().getSortOrder() == this.SORT_ORDER;
        }
        IoUtil.assertFileIsWritable(this.OUTPUT);
        if (matchedSortOrders || this.SORT_ORDER == SAMFileHeader.SortOrder.unsorted || this.ASSUME_SORTED) {
            log.info("Input files are in same order as output so sorting to temp directory is not needed.");
            headerMergerSortOrder = this.SORT_ORDER;
            mergingSamRecordIteratorAssumeSorted = this.ASSUME_SORTED;
            presorted = true;
        } else {
            log.info("Sorting input files using temp directory " + this.TMP_DIR);
            headerMergerSortOrder = SAMFileHeader.SortOrder.unsorted;
            mergingSamRecordIteratorAssumeSorted = false;
            presorted = false;
        }
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(headerMergerSortOrder, headers, this.MERGE_SEQUENCE_DICTIONARIES);
        MergingSamRecordIterator iterator = new MergingSamRecordIterator(headerMerger, readers, mergingSamRecordIteratorAssumeSorted);
        SAMFileHeader header = headerMerger.getMergedHeader();
        for (String comment : this.COMMENT) {
            header.addComment(comment);
        }
        header.setSortOrder(this.SORT_ORDER);
        SAMFileWriterFactory samFileWriterFactory = new SAMFileWriterFactory();
        if (this.USE_THREADING) {
            samFileWriterFactory.setUseAsyncIo(true);
        }
        SAMFileWriter out = samFileWriterFactory.makeSAMOrBAMWriter(header, presorted, this.OUTPUT);
        long numRecords = 1L;
        while (iterator.hasNext()) {
            SAMRecord record = iterator.next();
            out.addAlignment(record);
            if (numRecords % 1000000L == 0L) {
                log.info(numRecords + " records read.");
            }
            ++numRecords;
        }
        log.info("Finished reading inputs.");
        out.close();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.CREATE_INDEX.booleanValue() && this.SORT_ORDER != SAMFileHeader.SortOrder.coordinate) {
            return new String[]{"Can't CREATE_INDEX unless SORT_ORDER is coordinate"};
        }
        return null;
    }
}

