/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.BedGraphEntry;
import edu.unc.genomics.IntervalFactory;
import edu.unc.genomics.io.TextIntervalFileReader;
import java.io.IOException;
import java.nio.file.Path;
import net.sf.samtools.TabixWriter;
import org.apache.log4j.Logger;

public class BedGraphFileReader
extends TextIntervalFileReader<BedGraphEntry> {
    private static final Logger log = Logger.getLogger(BedGraphFileReader.class);

    public BedGraphFileReader(Path p) throws IOException {
        super(p, new BedGraphEntryFactory());
        log.debug((Object)("Opening BedGraph file reader " + p));
    }

    public static class BedGraphEntryFactory
    implements IntervalFactory<BedGraphEntry> {
        @Override
        public BedGraphEntry parse(String line) {
            return BedGraphEntry.parse(line);
        }

        @Override
        public TabixWriter.Conf tabixConf() {
            return TabixWriter.BED_CONF;
        }
    }
}

