/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import ed.javatools.BufferedRandomAccessFile;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.ContigIndex;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileFormatException;
import java.io.IOException;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

class FixedStepContigIndex
extends ContigIndex {
    private static final long serialVersionUID = -142695785731234833L;
    private int step;

    public FixedStepContigIndex(String chr, int start, int stop, int span, int step) {
        super(chr, start, stop, span);
        this.step = step;
    }

    public static FixedStepContigIndex parseHeader(String headerLine) throws WigFileFormatException {
        String[] tokens = headerLine.split("\\s+");
        if (tokens.length == 0 || !tokens[0].equals(Contig.Type.FIXEDSTEP.getId())) {
            throw new WigFileFormatException("Not a valid fixedStep header line: " + headerLine);
        }
        String chr = "";
        int start = 1;
        int span = 1;
        int step = 1;
        block12: for (int i = 1; i < tokens.length; ++i) {
            String s = tokens[i];
            String[] pair = s.split("=");
            if (pair.length != 2) {
                throw new WigFileFormatException("Invalid keypair in fixedStep header line: " + s);
            }
            String key = pair[0];
            String value = pair[1];
            switch (key) {
                case "chrom": {
                    chr = value;
                    continue block12;
                }
                case "start": {
                    start = Integer.parseInt(value);
                    continue block12;
                }
                case "span": {
                    span = Integer.parseInt(value);
                    continue block12;
                }
                case "step": {
                    step = Integer.parseInt(value);
                    continue block12;
                }
                default: {
                    throw new WigFileFormatException("Invalid attribute in fixedStep header line: " + key);
                }
            }
        }
        return new FixedStepContigIndex(chr, start, -1, span, step);
    }

    public long getLineNumForBasePair(int bp) throws WigFileException {
        if (bp < this.getStart() || bp > this.getStop()) {
            throw new WigFileException("Specified base pair (" + bp + ") does not exist in this Contig");
        }
        return this.getStartLine() + (long)((bp - this.getStart()) / this.step);
    }

    public int getBasePairForLineNum(long lineNum) throws WigFileException {
        if (lineNum < this.getStartLine() || lineNum > this.getStopLine()) {
            throw new WigFileException("Line " + lineNum + " is not a part of this contig");
        }
        return (int)((long)this.getStart() + (long)this.step * (lineNum - this.getStartLine()));
    }

    @Override
    public String toOutput() {
        return Contig.Type.FIXEDSTEP.getId() + " chrom=" + this.getChr() + " start=" + this.getStart() + " span=" + this.getSpan() + " step=" + this.step;
    }

    public int getStep() {
        return this.step;
    }

    @Override
    public boolean isFixedStep() {
        return true;
    }

    @Override
    public boolean isVariableStep() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(BufferedRandomAccessFile raf, Interval interval, float[] values) throws WigFileException, IOException {
        int low = Math.max(this.getStart(), interval.low());
        int high = Math.min(this.getStop(), interval.high());
        long startLine = this.getLineNumForBasePair(low);
        long stopLine = this.getLineNumForBasePair(high);
        int closestUpstream = this.getUpstreamIndexedBP(low);
        BufferedRandomAccessFile bufferedRandomAccessFile = raf;
        synchronized (bufferedRandomAccessFile) {
            long currentLine;
            raf.seek(this.getIndex(closestUpstream));
            for (currentLine = this.getLineNumForBasePair(closestUpstream); currentLine < startLine; ++currentLine) {
                raf.readLine2();
            }
            int bp = this.getBasePairForLineNum(currentLine);
            while (currentLine <= stopLine) {
                String line = raf.readLine2();
                ++currentLine;
                float value = Float.parseFloat(line);
                if (!Float.isNaN(value)) {
                    for (int i = bp; i <= bp + this.getSpan() - 1; ++i) {
                        if (!interval.includes(i)) continue;
                        values[i - interval.low()] = value;
                    }
                }
                bp += this.getStep();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillStats(BufferedRandomAccessFile raf, Interval interval, SummaryStatistics stats) throws WigFileException, IOException {
        int low = Math.max(this.getStart(), interval.low());
        int high = Math.min(this.getStop(), interval.high());
        long startLine = this.getLineNumForBasePair(low);
        long stopLine = this.getLineNumForBasePair(high);
        int closestUpstream = this.getUpstreamIndexedBP(low);
        BufferedRandomAccessFile bufferedRandomAccessFile = raf;
        synchronized (bufferedRandomAccessFile) {
            long currentLine;
            raf.seek(this.getIndex(closestUpstream));
            for (currentLine = this.getLineNumForBasePair(closestUpstream); currentLine < startLine; ++currentLine) {
                raf.readLine2();
            }
            int bp = this.getBasePairForLineNum(currentLine);
            while (currentLine <= stopLine) {
                String line = raf.readLine2();
                ++currentLine;
                float value = Float.parseFloat(line);
                if (!Float.isNaN(value)) {
                    for (int i = bp; i <= bp + this.getSpan() - 1; ++i) {
                        if (!interval.includes(i)) continue;
                        stats.addValue((double)value);
                    }
                }
                bp += this.getStep();
            }
        }
    }
}

