#!/usr/bin/env python
import subprocess, tempfile, sys, os
from optparse import OptionParser
#from commons.core.utils.RepetOptionParser import RepetOptionParser


class CufflinksGTFToBedWrapper(object):

    def __init__(self):
        self._options = None
        
        
    def stop_err(self, msg ):
        sys.stderr.write( "%s\n" % msg )
        sys.exit()
        
        
    def setAttributesFromCmdLine(self):
        #self._toolVersion = "1.0"
        description = "CufflinksGTFToBed "
        epilog = "\n parses a GTF file of Cufflinks and create a bed file. \n"
        epilog += "example: CufflinksGTFToBed.py -i <inputFile> -o  <outputFile>\n"
        #parser = RepetOptionParser(description = description, epilog = epilog, version = self._toolVersion) 
        parser = OptionParser(description = description, version = "1.0")
        parser.add_option("-i", "--inputFile",  dest = "inputFile",  action = "store", type = "string", help = "Input GTF File name(transcript.gtf of Cufflinks).",  default = "")
        parser.add_option("-o", "--outputFile", dest = "outputFile", action = "store", type = "string", help = "output Bed File name", default = "")
        parser.add_option("-v", "--verbosity",  dest = "verbosity",  action = "store", type = "int",    help = "Verbosity [optional] [default: 3]",default = 3)
        options = parser.parse_args()[0]
        self._setAttributesFromOptions(options)

    def _setAttributesFromOptions(self, options):
        self._options = options

    def run(self):
	tmp = "%s_tmp" % ((os.path.splitext(self._options.outputFile)[0]))
        prg = "CufflinksGTFToBed.py"
        args = ""
        args += "-i %s" % self._options.inputFile
	args += " "
        args += "-o %s" % tmp
        cmd = "%s %s" %(prg, args)
        print cmd
        
        try:
            tmp_err = tempfile.NamedTemporaryFile().name
            tmp_stderr = open( tmp_err, 'wb' )
            proc = subprocess.Popen( args=cmd, shell=True, cwd=".", stderr=tmp_stderr )
            returncode = proc.wait()
            tmp_stderr.close()
            # get stderr, allowing for case where it's very large
            tmp_stderr = open( tmp_err, 'rb' )
            stderr = ''
            buffsize = 1048576
            try:
                while True:
                    stderr += tmp_stderr.read( buffsize )
                    if not stderr or len( stderr ) % buffsize != 0:
                        break
            except OverflowError:
                pass
            tmp_stderr.close()
            if stderr:
                raise Exception, stderr
        except Exception, e:
            self.stop_err( 'Error in TranscriptToBed:\n' + str( e ) ) 
	try:
            cmdsort= "bedtools sort -i %s > %s" % (tmp, self._options.outputFile)
            os.system(cmdsort)
        except Exception, e:
            self.stop_err( 'Error in bedtools sort:\n' + str( e ) )

        
if __name__ == "__main__":
    iWrapper = CufflinksGTFToBedWrapper()
    iWrapper.setAttributesFromCmdLine()
    iWrapper.run()    
