#!/usr/bin/env perl
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Written (W) 2010 Vipin T. Sreedharan, Friedrich Miescher Laboratory of the Max Planck Society
# Copyright (C) 2010 Max Planck Society
#
# Description: - read fixedStep and variableStep wiggle input data,
#		output four column bedGraph format data

use warnings;
use strict;

my ($position, $chr, $step, $span) = (0, "", 1, 1);

my $usage = q(
fixedStep2BED.pl  - Program to convert a valid fixedStep or variableStep wiggle input data to BED format.
USAGE: wig2bedGraph_converter <fixedStep/variableStep Wiggle format> > <output file name>

);
if (scalar(@ARGV) != 1) {
    print $usage;
    exit
}

my $inFile = $ARGV[0];
open WIG, "<$inFile" || die "Can't open the Wiggle file \n";
while (my $dataValue = <WIG>)
{
    chomp $dataValue;
    next if ( $dataValue =~ m/^track /);
    if ( $dataValue =~ m/^fixedStep/ || $dataValue =~ m/^variableStep/ ) {
        ($position, $chr, $step, $span) = (0, "", 1, 1);
        my @a = split('\s', $dataValue);
        for (my $i = 1; $i < scalar(@a); ++$i) {
            my ($ident, $value) = split('=',$a[$i]);
            if ($ident =~ m/chrom/) { $chr = $value; }
            elsif ($ident =~ m/start/) { $position = $value-1; }
            elsif ($ident =~ m/step/) { $step = $value; }
            elsif ($ident =~ m/span/) { $span = $value; }
            else {
                print STDERR "ERROR: unrecognized fixedStep/variableStep line: $dataValue\n";
                exit 255;
            }
        }
    } 
    else {
        my @b = split('\s', $dataValue);
        if (scalar(@b)>1) {
            $position = $b[0];
            $dataValue = $b[1];
        }
        my $loc_pos = $position+$span;
        print "$chr\t$position\t$loc_pos\t$dataValue\n";
        $position = $position + $step;
    }
}
close WIG;
exit;
