#/bin/bash
include ../bin/rdiff_config.sh

set -e 

echo
echo ${PROG}: This program is part of the rDiff version $RDIFF_VERSION.
echo
echo rDiff performs differential expression testing from RNA-Seq measurements.
echo

if [ -z "$1" -o "$1" == '--help' ];
then
echo Usage: $0 poisson\|param\|nonparam
  echo " or:" $0 --help
  false
fi
if [ "$1" != 'poisson' -a "$1" != 'param' -a "$1" != 'nonparam' ];
then
echo invalid parameter: $1
  false
fi



../bin/rdiff -o results -d data/ -a example_condition_A_replicate_1.bam,example_condition_A_replicate_2.bam -b example_condition_B_replicate_1.bam,example_condition_B_replicate_2.bam -g data/genes_example.gff3 -m $1
