#!/bin/bash 
set -e

fasta=$1
library=$2
outputfile=$3
outputmaskedfile=$4
outputlog=$5
outputconfig=$6
outputStats=$7
classif=$8
outputmasked_SSRmaskfile=$9

projectname=$(date "+%Y%m%d")

add=''

if [ -f $classif ]
then
  add='-c '$classif
fi

if [ -f $outputStats ]
then
  add=$add' -s'
fi

`dirname $0`'/'TEannot_lite.py -i $fasta -l $library -o $outputfile $add > $outputlog 
projectname_complete=$(ls $(pwd)|grep $projectname)
working_dir=$(pwd)/$projectname_complete
sed -i 's@'"$working_dir"'@'$projectname'@g' $outputlog
mv $outputfile-$projectname.gff3 $outputfile
mv $outputfile-$projectname.mask $outputmaskedfile
mv $outputfile-$projectname.mask_SSRmask.fa $outputmasked_SSRmaskfile
if [ -f $outputStats ]
then
  mv $outputfile-$projectname-TEstats.txt $outputStats
fi

workingconfigfile=$working_dir/TEannot_Galaxy_config_$projectname_complete
sed -i 's|repet_host:.*|repet_host:|g' $workingconfigfile
sed -i 's|repet_user:.*|repet_user:|g' $workingconfigfile
sed -i 's|repet_pw:.*|repet_pw:|g' $workingconfigfile
sed -i 's|repet_db:.*|repet_db:|g' $workingconfigfile
sed -i 's|repet_port:.*|repet_port:|g' $workingconfigfile
sed -i 's|repet_job_manager:.*|repet_job_manager:|g' $workingconfigfile
sed -i 's|project_name:.*|project_name: '$projectname'|g' $workingconfigfile
sed -i 's|project_dir:.*|project_dir:|g' $workingconfigfile
sed -i 's|tmpDir:.*|tmpDir:|g' $workingconfigfile
mv $workingconfigfile $outputconfig
