'''
change start and end of interval files
'''

import sys

def resize(infile,outfile,expr_start,expr_end,strand):
    fin = open(infile)
    fout = open(outfile,'w')
    if expr_start[0:3] == 'end':
        c1 = 2
        n1 = int(expr_start[3:])
    else:
        c1 = 1
        n1 = int(expr_start[5:])
    if expr_end[0:3] == 'end':
        c2 = 2
        n2 = int(expr_end[3:])
    else:
        c2 = 1
        n2 = int(expr_end[5:])
    if strand == 'ignore':
        for line in fin:
            flds = line.strip().split('\t')
            start = int(flds[c1]) + n1
            if start >= 0:
                end = int(flds[c2]) + n2
                if end >= start:
                    flds[1] = str(start)
                    flds[2] = str(end)
                    fout.write('\t'.join(flds)+'\n')
    else:# upstream downstream
       for line in fin:
            flds = line.strip().split('\t')
            if flds[5] == '+':
                start = int(flds[c1]) + n1
                if start >= 0:
                    end = int(flds[c2]) + n2
                    if end >= start: 
                        flds[1] = str(start)
                        flds[2] = str(end)
                        fout.write('\t'.join(flds)+'\n')
            else: # on the - strand
                start = int(flds[3-c2]) - n2 # end=end+n2
                if start >= 0:
                    end = int(flds[3-c1]) - n1
                    if end >= start:
                        flds[1] = str(start)
                        flds[2] = str(end)
                        fout.write('\t'.join(flds)+'\n')
    fin.close()
    fout.close()

if __name__ == "__main__":
    resize(sys.argv[1],sys.argv[2],sys.argv[3],sys.argv[4],sys.argv[5])
    # python resize.py in.bed out.bed start-3 end+5 both
    # python resize.py <input.bed> <output.bed> expr_start expr_end strand(both/+/-)
