#!/bin/sh

##
## Galaxy wrapper for AWK command
##

##
## command line arguments:
##   input_file
##   output_file
##   awk-program
##   input-field-separator
##   output-field-separator

INPUT="$1"
OUTPUT="$2"
PROG="$3"
FS="$4"
OFS="$5"

shift 5

if [ -z "$OFS" ]; then
	echo usage: $0 INPUTFILE OUTPUTFILE AWK-PROGRAM FS OFS>&2
	exit 1
fi

if [ ! -r "$INPUT" ]; then
	echo "error: input file ($INPUT) not found!" >&2
	exit 1
fi

if [ "$FS" == "tab" ]; then
	FS="\t"
fi
if [ "$OFS" == "tab" ]; then
	OFS="\t"
fi

# Messages printed to STDOUT will be displayed in the "INFO" field in the galaxy dataset.
# This way the user can tell what was the command
echo "awk" "$PROG"

awk --sandbox -v OFS="$OFS" -v FS="$FS" --re-interval "$PROG" "$INPUT" > "$OUTPUT"
if (( $? ));  then exit; fi

exit 0
