
import os,sys

file1 = sys.argv[1]
file2 = sys.argv[2]
genome = sys.argv[3]
outplot = sys.argv[4]
outlog = sys.argv[5]
outbed = sys.argv[6]

strandness = ''
if len(sys.argv) > 7:   
    strandness = sys.argv[7]

# real distance
cmd = 'closestBed -a '+file1+' -b '+file2 + ' '+strandness + ' -d -t first > '+outbed
os.system(cmd)
# shuffle
cmd = 'shuffleBed -chrom -g '+genome+' -i '+file1+'> shuffled.bed'
os.system(cmd)
# shuffled distance
cmd = 'closestBed -a shuffled.bed -b '+file2 + ' '+strandness + ' -d -t first > shuffled.dist'
os.system(cmd)


# test in R
r = open('tmp.r','w')
r.write("options(warn=-1)\n")
r.write("source('/Users/xuebing/galaxy-dist/tools/mytools/cdf.r')\n")
r.write("x = read.table('"+outbed+"',sep='\t')\n")
r.write("y = read.table('shuffled.dist',sep='\t')\n")
r.write("pdf('"+outplot+"')\n")
r.write("mycdf(list(log10(1+x[,ncol(x)]),log10(1+y[,ncol(y)])),'spatial distance',c('real','shuffled'),'topleft','log10 distance','')\n")
r.write("dev.off()\n")
r.close()
os.system("R --vanilla < tmp.r >"+outlog)
