#!/usr/bin/env python

import sys, re
import os
import tempfile
import shutil, subprocess, glob
import optparse
from os.path import basename
import zipfile, tarfile, gzip
from galaxy.datatypes.checkers import *
from adlib import *

"""

Created by Yvan Le Bras
yvan.le_bras@irisa.fr

Last modifications : 01/10/2014

"""


def __main__():
	

	# arguments recuperation
	parser = optparse.OptionParser()
	parser.add_option("-P")
	parser.add_option("--evanno")
	parser.add_option("--clumpp")
	# multifile management
	parser.add_option("--logfile")
	# output management
        parser.add_option("--id")
        parser.add_option("--workdir")
        parser.add_option("--compress_output")
        # additionnal outputs
        parser.add_option("--total_output")
	(options, args) = parser.parse_args()

        # create the working dir
        tmp_dir = tempfile.mkdtemp(dir=options.workdir)
        tmp_output_dir = tempfile.mkdtemp(dir=tmp_dir)

	print tmp_dir 

	# Structure_archive
	
	# parse config files
	tab_files=galaxy_config_to_tabfiles_for_STACKS(options.P)

	# check if zipped files are into the tab
	extract_compress_files_from_tabfiles(tab_files, tmp_dir)

	# create the structure harvester command input line
	cmd_files=" --dir "+tmp_dir+" --out "+tmp_output_dir+" "
		
	# create the populations command line
	cmd_options=""

	if options.evanno and options.evanno == 'true':
		cmd_options+=" --evanno "
	if options.clumpp and options.clumpp == 'true':
		cmd_options+=" --clumpp "


	#print " "+cmd_files+" "+cmd_options

	# launch the command line
	
	#dev command
	cmd = '/local/galaxy/structureharv/structureHarvester.py'+cmd_files+" "+cmd_options+" 2>&1"

	#command with dependencies installed
	#cmd = 'structureHarvester.py'+cmd_files+" "+cmd_options+" 2>&1"
	proc = subprocess.Popen( args=cmd, shell=True )
	returncode = proc.wait()

	# postprocesses
        if os.path.exists(tmp_output_dir+'/summary.txt'):
                os.system('mv '+tmp_output_dir+'/summary.txt '+options.logfile)
        else:
                sys.stderr.write('Error in StructureHarvester execution; Please read the additional output (stdout)\n')


	print "\n[INFO] : "+cmd

        # copy all files inside tmp_dir into workdir or into an archive	
        list_files = glob.glob(tmp_output_dir+'/*')

	# if compress output is total
	if options.compress_output == 'total':
		mytotalzipfile=zipfile.ZipFile(tmp_output_dir+'/total.zip.temp', 'w')

		os.chdir(tmp_output_dir)
		for i in list_files:
			mytotalzipfile.write(os.path.basename(i))

		# return the unique archive
		os.system("mv "+tmp_output_dir+'/total.zip.temp'+" "+options.total_output)

	# if compress output is default
	else:
		for i in list_files:
			command = "mv "+i+" "+options.workdir+ "/primary_" + options.id + "_" + os.path.basename(i).replace("_", ".") + "_visible_tabular"
			proc = subprocess.Popen( args=command, shell=True )
			returncode = proc.wait()	

	
	#clean up temp files
	shutil.rmtree( tmp_dir )



if __name__ == "__main__": __main__()





