# raw2counts
# extract counts only from rawCounts
# and add rownames to counts

# input : rawCounts
# output : counts

# created Feb 6th, 2012
# modified April 12, 2012
# Marie-Agnes Dillies


raw2counts <- function( rawCounts, annot=1 ){

  ex <- 1:annot
  counts <- as.matrix( rawCounts[,-ex] )
  rownames(counts) <- rawCounts[,1]
  infoCounts <- rawCounts[,ex]
  return( list("counts"=counts, "infoCounts"= infoCounts) )
}
