#!/usr/bin/env python

"""
Yufei LUO
"""



import optparse, sys


def __main__():
    #Parse Command Line
    parser = optparse.OptionParser()
    parser.add_option('-i', '--inputs', dest='inputFiles', default=None, help='several input files. (seperated by @ or @@' )
    parser.add_option( '-o', '--output', dest='outputFile', default=None, help='The output list of HTSeq results files(.tabular) on txt format.' )
    ( options, args ) = parser.parse_args()

    
    out = open(options.outputFile, 'w')
    out.write("label\tfiles\tgroup\n")
    if options.inputFiles == None:
        raise Exception, 'input file name is not defined!'
    
    groupCount = 1
    fileCount = 0        
    
    inputFiles = sys.argv[6:]
    print '\n\nthe length of inputfiles is : %s \n' % len(inputFiles)
    i = 0
    while i < (len(inputFiles)-1):
        if inputFiles[i] == "@":
            i += 1
            fileCount = 1
            groupCount += 1
            out.write("Group%s_%s\t%s\t%s\n" % (groupCount, fileCount, inputFiles[i], groupCount))
        else:
	    fileCount += 1
            out.write("Group%s_%s\t%s\t%s\n" % (groupCount, fileCount, inputFiles[i], groupCount))
        i += 1
           
    out.close()   
    
        

if __name__=="__main__": __main__()
