# barplotNul
# barplot representing null counts per sample

# input : counts, target, projectName
# output : barplotNul (png)

# created Feb 7th, 2012
# modified April 30th, 2012 (target$group instead of target)
# Marie-Anges Dillies

barplotNul <- function( counts, group,  OUT_barplotNulName, out = TRUE ){

  if (out) png( file=OUT_barplotNulName )

  N <- apply(counts, 2, function(x){sum(x == 0)})/nrow(counts)
  barplot(N, col=as.integer(group)+1, main = "Proportion of null counts per Sample", ylim = c(0,1))
  legend("topright", as.character(unique(group)), lty=1, col=as.integer(unique(group))+1)

  if (out) dev.off()
}
