#!/bin/bash

OUTFile=${1}
shift
groupCount=1
replicateNumber=1

arrayZ=( $@ )
#remove the last symble '@' given by commande line
unset arrayZ[${#arrayZ[@]}-1]

for FILE in ${arrayZ[@]}
do
	#if a new group of fastq, re-count the replicateNumber
	if echo $FILE | grep -q "@" 
	then 
		groupCount=$(($groupCount + 1))
		replicateNumber=1
	else
		echo -e "Group${groupCount}_${replicateNumber}\t${FILE}" >>${OUTFile}
		replicateNumber=$(($replicateNumber + 1))
  	fi
done

