# loadCountData
# loads counts, one file per lane
# file names from target file

# input : target
# output : raw count table

# created Feb 6th, 2012
# modified May 2nd, 2012 (colnames -> target$label)
# Marie-Agnes Dillies


loadCountData <- function(target, header){

  require(DESeq)
  fileNames <- target$files

if(header!=0){
	#rawCounts <- read.table(as.character(paste(rawDir,target$files[1],sep="/")), sep="\t", header=TRUE)
	rawCounts <- read.table(as.character(target$files[1],sep="/"), sep="\t", header=TRUE)
} else if(header==0){
	rawCounts <- read.table(as.character(target$files[1],sep="/"), sep="\t")}
  
  colnames(rawCounts) <- c("Id", as.character(target$label[1]))

  for (i in 2:length(fileNames)){
	if(header!=0){
  		tmp <- read.table(as.character(target$files[i],sep="/"), sep="\t", header=TRUE)
	} else if(header==0){
		tmp <- read.table(as.character(target$files[i],sep="/"), sep="\t")}
  	colnames(tmp) <- c("Id", as.character(target$label[i]))
  	rawCounts <- merge(rawCounts, tmp, by="Id", all=T)
  }
  rawCounts[is.na(rawCounts)] <- 0
  return(rawCounts)
}
