# clusterPlot
# dendrogram of sample clustering

# input : counts, outputName, type of data (raw or norm)
# output : dendrogram (jpeg)

# created Sept 13th, 2012
# modified Oct 30th, 2012
# Marie-Agnes Dillies


clusterPlot <- function( cds, OUT_clusterPlot, type = "raw", out = TRUE ){

  if (out) png( file=OUT_clusterPlot )

  if (type == "norm"){
    cdsblind <- estimateDispersions( cds, method="blind" )
    vsd <- getVarianceStabilizedData( cdsblind )
  }
  else {
    vsd <- counts(cds)
  }
  hc <- hclust( dist(t(vsd)), method="ward" )
  plot( hc, xlab = "Euclidean distance, Ward criterion", main=paste("Cluster Dendrogram, ", type, " data", sep="") )

  if (out) dev.off()
}
