# exportComplete
# export complete data and results

# input : counts res, target
# output : complete data and xls file (in text format)

# created Feb 14th, 2012
# modified March 9th, 2012 (order of cond1 and cond2)
# Marie-Anges Dillies

exportComplete <- function( counts, res, target, adjMethod, cond1, cond2, OUT_completeName, out = T ){
	
	complete <- data.frame( res$id, counts, res[,3:ncol(res)] )
	colnames(complete) <- c( "id", as.character(target$label), cond2, cond1, "FC", "log2FC", "rawp", 
							paste("adjp",adjMethod,sep="") )

  if (out)
  		write.table( complete, file=OUT_completeName, sep="\t", row.names=F )
  return( complete )
}
