# exportDiff
# export differentially expressed genes

# input : complete, alpha, adjMethod, projectName
# output : diff genes, up and down in xls files

# created Feb 14th, 2012
# Marie-Anges Dillies

exportDiff <- function( complete, alpha, adjMethod, OUT_upName, OUT_downName, out = T ){
	
	diff <- complete[which(complete[,grep("adjp",colnames(complete))] < alpha),]

	gup <- up( diff )	
	gdown <- down( diff )
	
  if (out){
    gup[,(ncol(gup)-4):ncol(gup)] <- format( gup[,(ncol(gup)-4):ncol(gup)], digits=3, dec=",")
    gdown[,(ncol(gdown)-4):ncol(gdown)] <- format( gdown[,(ncol(gdown)-4):ncol(gdown)], digits=3, dec=",")
		write.table(gup, file=OUT_upName, row.names=F, sep="\t")
		write.table(gdown, file=OUT_downName, row.names=F, sep="\t")
  }	
  return( diff )
}


up <- function( diff ){
		
	up <- diff[diff$log2FC > 0,]
	up <- up[order(up[,grep("adjp",colnames(up))]),]

	return( up )	
}


down <- function( diff ){
		
	down <- diff[diff$log2FC < 0,]
	down <- down[order(down[,grep("adjp",colnames(down))]),]

	return( down )	
}
