# boxplotCounts
# boxplots representing counts distribution per sample

# input : counts, target, projectName, type of data (raw or norm)
# output : boxplot (png)

# created Feb 7th, 2012
# modified April 30th, 2012
# Marie-Anges Dillies

boxplotCounts <- function( counts, group, type = c("raw", "norm"), OUT_boxplotCountsName, out = TRUE ){

  if (out) png( file=OUT_boxplotCountsName )

  boxplot( log2(counts+1), col=as.integer(group)+1, main = paste(type[1], " counts distribution", sep="" ) )
  legend( "topright", as.character(unique(group)), lty=1, col=as.integer(unique(group))+1 )

  if (out) dev.off()
}
