# majSequence
# compute proportion of reads associated with most expressed sequence

# input : counts, target, projectName
# output : barplot, % associated with majority gene

# created Feb 7th, 2012
# modified Feb 20th, 2012
# modified April 30th, 2012
# Marie-Agnes Dillies


majSequence <- function( counts, group, OUT_majSequenceName, out = T, position = "topright" ){

  if (out) png( file=OUT_majSequenceName )

  maj <- apply(counts, 2, function(x){x <- x[order(x, decreasing=T)]; x[1]*100/sum(x)})
  seqname <- apply(counts, 2, function(x){x <- x[order(x, decreasing=T)]; names(x)[1]})

  x <- barplot( maj, col=as.integer(group)+1, main = "Proportion of reads from most expressed gene", 
		ylim = c(0, max(maj)*1.2), cex.main=0.8 )
  for (i in 1:length(seqname)) text( x[i], maj[i]/2, seqname[i], cex=0.8, srt=90, adj=0)
  legend( position, as.character(unique(group)), lty=1, col=as.integer(unique(group))+1 )

  if (out) dev.off()
}
