# Marie-Anges Dillies
# histoRawp
# histogram of raw p-values

# input : res, OUT_histoRawpName
# output : histogram (png)


histoRawp <- function( res, OUT_histoRawpName, out = TRUE ){

  if (out) png( file=OUT_histoRawpName )
  
  ind <- grep("val", colnames(res))
  hist( res[,ind], nclass=50, xlab="Raw p-values", main="", col="skyblue" )

  if (out) dev.off()
}


