import os
import unittest
import commons.pyRepetUnit.hmmer.hmmOutput.HmmpfamOutputProcessing
from commons.core.utils.FileUtils import FileUtils

class Test_F_Hmmerpfam2align(unittest.TestCase):
    
    def setUp(self):
        self.hmmpfamOutputProcess = commons.pyRepetUnit.hmmer.hmmOutput.HmmpfamOutputProcessing.HmmpfamOutputProcessing()
        self._inputFile = "./datas/test_hmmpfam_output" 
        self._outputFile =  "./datas/PostProcessResult.align" 
        
    def testAcceptanceHmmpfam2align(self):
        self.hmmpfamOutputProcess.readHmmOutputsAndWriteAlignFile( self._inputFile, self._outputFile )
        self.assertTrue(FileUtils.isRessourceExists(self._outputFile))
        self.assertTrue(FileUtils.are2FilesIdentical(self._inputFile + ".align", self._outputFile))
        os.remove(self._outputFile)
        
if __name__ == "__main__":                 
    unittest.main()