import unittest
import os
import time
from commons.core.tree.Tree import Tree
from commons.core.utils.FileUtils import FileUtils


class Test_Tree( unittest.TestCase ):
    
    def setUp( self ):
        self._tree = Tree()
        self._uniqId = "%s_%s" % ( time.strftime("%Y%m%d%H%M%S") , os.getpid() )
        
        
    def test_parseTree_oneLeaf( self ):
        inString = "seq1:0.0023"
        obs = self._tree.parseTree( inString )
        exp = { "left":None, "right":None, "name":"seq1", "length":0.0023 }
        self.assertEqual( obs, exp )
        
        
    def test_parseTree_twoLeaves( self ):
        inString = "(seq1:0.0023,seq2:0.0017)"
        obs = self._tree.parseTree( inString )
        exp = {'length':0, 'right':{'length':0.0016999999999999999, 'right':None, 'name':'seq2', 'left':None}, 'name':'internal', 'left':{'length':0.0023, 'right':None, 'name':'seq1', 'left':None}}
        self.assertEqual( obs, exp )
        
##     def test_parseTree_threeLeaves( self ):
##         inString = "(seq1:0.0023,(seq2:0.0017,seq3:0.0009))"
##         obs = self._tree.parseTree( inString )
##         print obs
##         exp = {'length':0, 'right':{'length':0.0016999999999999999, 'right':None, 'name':'seq2', 'left':None}, 'name':'internal', 'left':{'length':0.0023, 'right':None, 'name':'seq1', 'left':None}}
##         self.assertEqual( obs, exp )
        
        
    def test_parseSubTree( self ):
        inString = "(seq1:0.0023,seq2:0.0017)"
        lExp = [ "seq1:0.0023", "seq2:0.0017" ]
        lObs = self._tree.parseSubTree( inString )
        self.assertEqual( lObs, lExp )
        
        
    def test_saveTree( self ):
        inFileName = "dummyInFile_%s" % ( self._uniqId )
        inF = open( inFileName, "w" )
        inF.write( "(seq4:0.012511,(seq3:0.005340,seq2:0.002201))" )
        inF.close()
        self._tree = Tree( inFileName )
        obsFileName = "dummyObsFile_%s" % ( self._uniqId )
        self._tree.saveTree( obsFileName )
        self.assertTrue( FileUtils.are2FilesIdentical( obsFileName, inFileName ) )
        for f in [ inFileName, obsFileName ]:
            os.remove( f )
            
            
    def test_retrieveInitialSequenceHeaders( self ):
        inString = "(seq4:0.012511,(seq3:0.005340,seq2:0.002201))"
        self._tree.tree = self._tree.parseTree( inString )
        dNew2Init = { "seq2":"consensus524::215 dmel_chr4 142..765", "seq3":"DmelChr4-B-G387-MAP16", "seq4":"1360|1cl-3gr" }
        expFileName = "dummyExpFile_%s"  % ( self._uniqId )
        expF = open( expFileName, "w" )
        expF.write( "(1360|1cl-3gr:0.012511,(DmelChr4-B-G387-MAP16:0.005340,consensus524-215_dmel_chr4_142..765:0.002201))" )
        expF.close()
        obsFileName = "dummyObsFile_%s"  % ( self._uniqId )
        self._tree.retrieveInitialSequenceHeaders( dNew2Init, obsFileName )
        self.assertTrue( FileUtils.are2FilesIdentical( obsFileName, expFileName ) )
        for f in [ expFileName, obsFileName ]:
            os.remove( f )
            
            
    def test_getNbOfLeaves( self ):
        inString = "(seq4:0.012511,(seq3:0.005340,seq2:0.002201))"
        self._tree.tree = self._tree.parseTree( inString )
        exp = 3
        obs = self._tree.getNbOfLeaves()
        self.assertEqual( obs, exp )
        
        
    def test_getNbOfNodes( self ):
        inString = "(seq4:0.012511,(seq3:0.005340,seq2:0.002201))"
        self._tree.tree = self._tree.parseTree( inString )
        exp = 4
        obs = self._tree.getNbOfNodes()
        self.assertEqual( obs, exp )
        
        
test_suite = unittest.TestSuite()
test_suite.addTest( unittest.makeSuite( Test_Tree ) )
if __name__ == "__main__":
    unittest.TextTestRunner(verbosity=2).run( test_suite )
