import os
import unittest
from commons.pyRepetUnit.align.hmmOutputParsing.HmmpfamOutput2align import HmmpfamOutput2align
from commons.core.utils.FileUtils import FileUtils

class Test_F_HmmpfamOutput2align(unittest.TestCase):
    
    def setUp(self):
        self.hmmpfamOutput2align = HmmpfamOutput2align()
        self._inputFile = "./datas/test_hmmpfam_output"
        self._outputFile = "./datas/hmmpfam_output.align"
        
    def testParseHmmpfamOutput2align(self):
        self.hmmpfamOutput2align.setInputFile(self._inputFile)
        self.hmmpfamOutput2align.setOutputFile(self._outputFile)
        self.hmmpfamOutput2align.run()
        self.assertTrue(FileUtils.isRessourceExists(self._outputFile))
        self.assertTrue(FileUtils.are2FilesIdentical(self._inputFile + ".align", self._outputFile))
        os.remove( self._outputFile )
        
if __name__ == "__main__":                 
    unittest.main()