#! /usr/bin/env python
"""Convert files with some mapping format to coordinates format"""

import os
from optparse import OptionParser
from parsing.pslParser import *
from parsing.axtParser import *
from writer.gff3Writer import *
from writer.mySqlTranscriptWriter import *
from structure.transcriptListsComparator import *
from misc.progress import *


if __name__ == "__main__":
  
  # parse command line
  description = "Mapping To Coordinates: Convert a set of mappings (given by a mapping tool) to a set of transcripts. [Category: Mappings]"

  parser = OptionParser(description = description)
  parser.add_option("-i", "--input",           dest="inputFileName",  action="store",                     type="string", help="input file [compulsory] [format: file in mapping format given by -f]")
  parser.add_option("-f", "--format",          dest="format",         action="store",                     type="string", help="format of file [compulsory] [format: mapping file format]")
  parser.add_option("-o", "--output",          dest="output",         action="store",      default=None,  type="string", help="output file [compulsory] [format: output file in GFF3 format]")
  parser.add_option("-y", "--mysql",           dest="mysql",          action="store_true", default=False,                help="mySQL output [format: bool] [default: false]")
  parser.add_option("-v", "--verbosity",       dest="verbosity",      action="store",      default=1,     type="int",    help="trace level [format: int]")
  parser.add_option("-l", "--log",             dest="log",            action="store",      default=None,  type="string", help="write a log file [format: bool]")
  (options, args) = parser.parse_args()

  logHandle = None
  if options.log != None:
    logHandle = open(options.log, "w")
  
  print "Reading input file..."
  parser = TranscriptContainer(options.inputFileName, options.format, options.verbosity)
  print "... done"
    
  writer = Gff3Writer("%s.gff3" % (options.output), options.verbosity)
  if options.mysql:
    sqlWriter = MySqlTranscriptWriter(options.output, options.verbosity)
    
  progress = Progress(parser.getNbTranscripts(), "Reading %s" % (options.inputFileName), options.verbosity)
  for transcript in parser.getIterator():
    writer.addTranscript(transcript)
    if options.mysql:
      sqlWriter.addTranscript(transcript)
    progress.inc()
  progress.done()
  
  if options.mysql:
    sqlWriter.write()
