from commons.core.parsing.BlatToGff import BlatToGff
import unittest


class Test_BlatToGff(unittest.TestCase):


    def test_convertBlatObjectToGffLine(self):
        blatLine = '315\t20\t0\t0\t3\t10\t2\t9\t+\tMRRE1H001H13FM1\t378\t0\t345\tchr16\t22053297\t21686950\t21687294\t4\t76,185,7,67,\t0,77,263,278,\t21686950,21687026,21687213,21687227,\n'
        nbLine = 15
        iBlatToGff = BlatToGff()
        BlatToGff._methodName = ''
        obsGffLine = iBlatToGff.convertBlatObjectToGffLine(blatLine, nbLine)
        expGffLine = 'chr16\tBlatToGff\tBES\t21686950\t21687294\t.\t+\t.\tID=MRRE1H001H13FM1;Name=MRRE1H001H13FM1;bes_start=21686950;bes_end=21687294;bes_size=22053297\n'
        self.assertEquals(expGffLine, obsGffLine)

    def test_convertBlatObjectToGffLine_with_methodName(self):
        blatLine = '315\t20\t0\t0\t3\t10\t2\t9\t+\tMRRE1H001H13FM1\t378\t0\t345\tchr16\t22053297\t21686950\t21687294\t4\t76,185,7,67,\t0,77,263,278,\t21686950,21687026,21687213,21687227,\n'
        nbLine = 15
        iBlatToGff = BlatToGff()
        BlatToGff._methodName = 'Test'
        obsGffLine = iBlatToGff.convertBlatObjectToGffLine(blatLine, nbLine)
        expGffLine = 'chr16\tBlatToGff\tTest:BES\t21686950\t21687294\t.\t+\t.\tID=MRRE1H001H13FM1;Name=MRRE1H001H13FM1;bes_start=21686950;bes_end=21687294;bes_size=22053297\n'
        self.assertEquals(expGffLine, obsGffLine)


if __name__ == "__main__":
    unittest.main()