import os
import unittest
from commons.pyRepetUnit.align.hmmOutputParsing.HmmscanOutput2align import HmmscanOutput2align
from commons.core.utils.FileUtils import FileUtils 

CURRENT_DIR = os.getcwd()

class Test_F_HmmscanOutput2align(unittest.TestCase):

    def setUp(self):
        self.hmmscanOutput2align = HmmscanOutput2align()
        self._inputFile = os.environ["REPET_PATH"] + "/commons/pyRepetUnit/hmmer/hmmOutput/tests/datas/hmmscanOutput"
        self._outputFile = "./datas/test_hmmscanOutput.align"
        os.chdir(CURRENT_DIR)

    def testParseHmmscanOutput2align(self):
        self.hmmscanOutput2align.setInputFile(self._inputFile)
        self.hmmscanOutput2align.setOutputFile(self._outputFile)
        self.hmmscanOutput2align.run()
        expectedFile = os.environ["REPET_PATH"] + "/commons/pyRepetUnit/hmmer/hmmOutput/tests/datas/hmmscanOutput.align"
        self.assertTrue(FileUtils.isRessourceExists(self._outputFile))
        self.assertTrue(FileUtils.are2FilesIdentical(expectedFile, self._outputFile))
        os.remove( self._outputFile )
        

if __name__ == "__main__":
    unittest.main()