#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
"""
Some functions about bins
"""

def getMinBin():
    return 3


def getMaxBin():
    return 7


def getBin(start, end):
    for i in range(getMinBin(), getMaxBin() + 1):
        binLevel = 10 ** i
        if int(start / binLevel) == int(end / binLevel):
            return int(i * 10 ** (getMaxBin() + 1) + int(start / binLevel))
    return int((getMaxBin() + 1) * 10 ** (getMaxBin() + 1))


def getOverlappingBins(start, end):
    array  = []
    bigBin = int((getMaxBin() + 1) * 10 ** (getMaxBin() + 1))
    for i in range(getMinBin(), getMaxBin() + 1):
        binLevel = 10 ** i
        array.append((int(i * 10 ** (getMaxBin() + 1) + int(start / binLevel)), int(i * 10 ** (getMaxBin() + 1) + int(end / binLevel))))
    array.append((bigBin, bigBin))
    return array


def getIterator(maxValue = None):
    if maxValue == None:
        maxValue = 10 ** (getMaxBin() + getMinBin()) - 1
    for i in range(getMinBin(), getMaxBin() + 1):
        binLevel = 10 ** i
        binBit   = i * 10 ** (getMaxBin() + 1)
        for j in range(0, maxValue / binLevel+1):
            yield binBit + j
    yield int((getMaxBin() + 1) * 10 ** (getMaxBin() + 1))


def getNbBins(maxValue = None):
    if maxValue == None:
        maxValue = 10 ** (getMaxBin() + getMinBin()) - 1
    nbBins = 0
    for i in range(getMinBin(), getMaxBin() + 1):
        nbBins += maxValue / 10 ** i
    return nbBins + 1
