#!/usr/bin/env python

"""
Launcher for the multifasta parser.
@param b: Name of the batch of sequences
@param g: Name of the gene
@param t: Scientific name of the taxon concerned
@param f: Name of the multifasta input file  
"""


import os
import sys
import getopt
from commons.core.parsing.Multifasta2SNPFile import Multifasta2SNPFile

CURRENT_DIR = os.getcwd()

def help():
        
    """
    Give the list of the command-line options.
    """
        
    print "Usage: ",sys.argv[0],"[ options ]"
    print "     -h: this help"
    print "Mandatory option:"
    print "     -t: Scientific name of the taxon concerned"
    print "Exclusive options (use either the first or the second, one should be used)"
    print "     -f: Name of the multifasta input file in one batch mode"
    print "     -d: Name of the directory containing multifasta input file(s) in multi-batch mode"
    print "Only in one batch mode: mandatory options (when -f is used):"    
    print "     -b: Name of the batch of submitted sequences"
    print "     -g: Name of the gene"
    print ""
    

def runOneInputFile(batchName, geneName, taxon, inputFileName):
    print "Multifasta parseur launched:!\n"
    print "-- Input File: " + inputFileName + "\n"
    print "-- Batch name: " + batchName + "\n"
    print "-- Gene name: " + geneName + "\n"
    print "-- Taxon: " + taxon + "\n"
    #TODO: gerer le delete des fichiers(mode append)
    multifasta2SNPFile = Multifasta2SNPFile(taxon, batchName, geneName)
    multifasta2SNPFile.runOneBatch(inputFileName)
    print "OK: Files generated!"


def runSeveralInputFile(taxon, rootDirectoryName):
    multifasta2SNPFile = Multifasta2SNPFile(taxon)
    multifasta2SNPFile.runSeveralBatches(rootDirectoryName)

def main():
    batchName = ""
    geneName = ""
    taxon = ""
    inputFileName = ""
    rootDirectoryName = ""
    
    
    try:
        opts,args = getopt.getopt(sys.argv[1:],"hb:g:t:f:d:")
    except getopt.GetoptError:
        print "Invalid options\n"
        help()
        sys.exit(2)

    for o, a in opts:
        if o == "-h":
            help()
            exit(0)
        elif o == "-b":
            batchName = a
        elif o == "-g":
            geneName = a
        elif o == "-t":
            taxon = a
        elif o == "-f":
            inputFileName = a
        elif o == "-d":
            rootDirectoryName = os.path.abspath(a)
            
    if taxon == "":
        print "*** Error: The mandatory option -t is missing"
        help()
        sys.exit(1)
    
    if (inputFileName == "" and  rootDirectoryName == "") or (inputFileName != "" and  rootDirectoryName != ""):
        print "*** Error: You have to specify the input mode: choose either -f (for one file) or -d (for one directory of several files)"
        help()
        sys.exit(1)
        
    if(inputFileName != ""):
        if batchName == "" or geneName == "":
            print "*** Error: A mandatory option is missing in one batch mode (-b or -g)"
            help()
            sys.exit(1)
    
    if(inputFileName != ""):
        runOneInputFile(batchName, geneName, taxon, inputFileName)
    else:
        runSeveralInputFile(taxon, rootDirectoryName)
    
    
    return 0

#------------------------------------------------------------------------------
if __name__ == "__main__":
    main()