#ifndef NC_LIST_CREATOR_HPP
#define NC_LIST_CREATOR_HPP

#include "ncList.hpp"
#include "table.hpp"
#include "genomicInterval.hpp"
#include <set>
#include <map>

typedef set<string> Chromosomes;
typedef map<string, NCList *> NCLists;

static const unsigned int H_CELL_SIZE = 2;
static const unsigned int L_CELL_SIZE = 4;
static const unsigned int T_CELL_SIZE = 5;

static const unsigned int START   = 0;
static const unsigned int END     = 1;
static const unsigned int LIST    = 2;
static const unsigned int PARENT  = 3;
static const unsigned int NEW     = 4;
static const unsigned int LENGTH  = 1;


class NCListCreator {

    private:
        string inputFileName;
        Table  *h, *l, *t;

        string getFileName(string chromosome);
        void buildLists(string chromosome);
        void createTables(string chromosome);
        void initLists(string chromosome);
        void fillTables(string chromosome);
        void labelLists();
        void computeSubStart();
        void computeAbsPosition();
        void cleanFiles();
        void transfer(string chromosome);
        unsigned int nbLists, nbLines;


    public:
        Chromosomes chromosomes;
        NCLists ncLists;

        NCListCreator (string inputFileName);

        void splitFile ();
        void run ();

};

#endif


