import re
import sys
from structure.mapping import *
from parsing.mapperParser import *


class NucmerParser(MapperParser):
  """A class that parses the output of Nucmer"""

  def __init__(self, fileName, verbosity = 0):
    super(NucmerParser, self).__init__(fileName, verbosity)


  def __del__(self):
    super(NucmerParser, self).__del__()


  def getFileFormats():
    return ["nucmer"]
  getFileFormats = staticmethod(getFileFormats)


  def skipFirstLines(self):
    while "======" not in self.handle.readline():
      self.currentLineNb += 1
      pass


  def parseLine(self, line):
    m = re.search(r"^\s*(\d+)\s+(\d+)\s+\|\s+(\d+)\s+(\d+)\s+\|\s+(\d+)\s+(\d+)\s+\|\s+(\d+\.?\d*)\s+\|\s+(\d+)\s+(\d+)\s+\|\s+(\d+\.?\d*)\s+(\d+\.?\d*)\s+\|\s+(\w+)\s+(\w+\.?\w*)\s*$", line)
    if m == None:
      sys.exit("\nLine %d '%s' does not have a NucMer format" % (self.currentLineNb, line))

    mapping = Mapping()

    mapping.targetInterval.setStart(min(int(m.group(1)), int(m.group(2))))
    mapping.targetInterval.setEnd(max(int(m.group(1)), int(m.group(2))))
    mapping.targetInterval.setSize(int(m.group(8)))
    mapping.targetInterval.setChromosome(m.group(12))

    mapping.queryInterval.setStart(min(int(m.group(3)), int(m.group(4))))
    mapping.queryInterval.setEnd(max(int(m.group(3)), int(m.group(4))))
    mapping.queryInterval.setSize(int(m.group(9)))
    mapping.queryInterval.setName(m.group(13))

    mapping.setDirection(int(m.group(4)) - int(m.group(3)))
    mapping.setSize(min(int(m.group(5)), int(m.group(6))))
    mapping.setIdentity(float(m.group(7)))

    return mapping
