import unittest
import os
from SMART.Java.Python.FindOverlapsOptim import FindOverlapsOptim
from SMART.Java.Python.ncList.test.MockFindOverlapsWithSeveralIntervals import *

class Test_FindOverlaps_optim(unittest.TestCase):

    def setUp(self):
        self._inputRefGff3FileName = 'sorted_Ref.gff3'
        iMock = MockFindOverlapsWithServeralIntervals_case1()
        iMock.write(self._inputRefGff3FileName)
        self._inputQueryGff3FileName = 'sorted_Query.gff3'
        self._writeQueryGff3File(self._inputQueryGff3FileName)
        self._outputGff3FileName = 'overlaps.gff3'
        self._iFOO = FindOverlaps_optim(self._inputRefGff3FileName, self._inputQueryGff3FileName)
        self._iFOO.prepareIntermediateFiles_sorted()
        self._iFOO.setOutputGff3FileName(self._outputGff3FileName)
        
    def tearDown(self):
        os.remove(self._inputRefGff3FileName)
        os.remove(self._inputQueryGff3FileName)
        os.remove(self._outputGff3FileName)
        self._iFOO.deletIntermediateFiles()
    
    def test_isOverlapping_true(self):
        queryGff3Addr = 116
        RefGff3Addr = 231
        obs = self._iFOO.isOverlapping(queryGff3Addr, RefGff3Addr)
        exp = 0
        self.assertEquals(exp, obs)
        
    def test_isOverlapping_false_left(self):
        queryGff3Addr = 116
        RefGff3Addr = 58
        obs = self._iFOO.isOverlapping(queryGff3Addr, RefGff3Addr)
        exp = -1
        self.assertEquals(exp, obs)
    
    def test_isOverlapping_false_right(self):
        queryGff3Addr = 116
        RefGff3Addr = 347
        obs = self._iFOO.isOverlapping(queryGff3Addr, RefGff3Addr)
        exp = 1
        self.assertEquals(exp, obs) 
           
    def test_getHisFirstChild(self):
        firstRefLAddr = 0
        obsFirstChildLAddr = self._iFOO.getHisFirstChild(firstRefLAddr)
        expFirstChildLAddr = 48
        self.assertEquals(expFirstChildLAddr, obsFirstChildLAddr) 
    
    def test_isLastElement_true(self):
        refLAddr = 96
        obsBool = self._iFOO.isLastElement(refLAddr)
        expBool = True
        self.assertEquals(expBool, obsBool)
    
    def test_isLastElement_false(self):
        refLAddr = 72
        obsBool = self._iFOO.isLastElement(refLAddr)
        expBool = False
        self.assertEquals(expBool, obsBool)  
        
    def test_isLastElement_highestLevel_true(self):
        refLAddr = 24
        obsBool = self._iFOO.isLastElement(refLAddr)
        expBool = True
        self.assertEquals(expBool, obsBool)
    
    def test_isLastElement_highestLevel_false(self):
        refLAddr = 0
        obsBool = self._iFOO.isLastElement(refLAddr)
        expBool = False
        self.assertEquals(expBool, obsBool)           

    def test_findOverlapIter(self):
        queryGff3Addr = 175
        firstRefLAddr = 0 
        done = False
        obsFirstOverlapLAddr = self._iFOO.findOverlapIter(queryGff3Addr, firstRefLAddr, done)
        expFirstOverlapLAddr = 96, True
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr)
        
    def test_not_findOverlapIter(self):
        queryGff3Addr = 295
        firstRefLAddr = 24 
        done = False
        obsFirstOverlapLAddr = self._iFOO.findOverlapIter(queryGff3Addr, firstRefLAddr, done)
        expFirstOverlapLAddr = None, False
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr)   
        
    def test_findOverlapIter_not_the_first_RefOverlap(self):
        queryGff3Addr = 235
        firstRefLAddr = 96 
        done = True
        obsFirstOverlapLAddr = self._iFOO.findOverlapIter(queryGff3Addr, firstRefLAddr, done)
        expFirstOverlapLAddr = 24, False
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr)  
        
    def test_changeToNewSubEndLAddr(self):
        firstChildLAddr = 48
        subEndLAddr = 48
        expSubEndLAddr = 120
        obsSubEndLAddr = self._iFOO.changeToNewSubEndLAddr(firstChildLAddr, subEndLAddr)
        self.assertEquals(expSubEndLAddr, obsSubEndLAddr) 
        
    def test_defineSubEndLaddr(self):
        parentLAddr = -1
        expSubEndLAddr = 48
        obsSubEndLAddr = self._iFOO.defineSubEndLaddr(parentLAddr)
        self.assertEquals(expSubEndLAddr, obsSubEndLAddr)
        
    def test_getNextRefIntervalInCaseNotOverLap(self):
        firstRefLAddr = 96
        expRefLAddr = 24
        obsRefLAddr = self._iFOO.getNext(firstRefLAddr)
        self.assertEquals(expRefLAddr, obsRefLAddr)
        

    def test_not_findOverlapIter_between2RefIntervals(self):
        inputQueryGff3FileName = 'query2.gff3'
        self._writeQueryGff3File2(inputQueryGff3FileName)
        self._iFOO.setQueryGff3FileName(inputQueryGff3FileName)
        queryGff3Addr = 0
        firstRefLAddr = 0
        done = False
        obsFirstOverlapLAddr = self._iFOO.findOverlapIter(queryGff3Addr, firstRefLAddr, done)
        expFirstOverlapLAddr = 24, False
        self.assertEquals(expFirstOverlapLAddr, obsFirstOverlapLAddr) 
        os.remove(inputQueryGff3FileName) 

    def _writeQueryGff3File2(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1\t1100\t1150\t126\t+\t.\tID=test1.1;Name=test1.1\n")
        f.write("chr1\tquery\ttest2\t1250\t1300\t781\t+\t.\tID=test1.2;Name=test1.2\n")
        f.close()  
        
    def _writeQueryGff3File(self, fileName):
        f = open(fileName, 'w')
        f.write("chr1\tquery\ttest1.1\t25\t150\t126\t+\t.\tID=test1.1;Name=test1.1\n")
        f.write("chr1\tquery\ttest1.2\t70\t850\t781\t+\t.\tID=test1.2;Name=test1.2\n")
        f.write("chr1\tquery\ttest1.3\t550\t850\t201\t+\t.\tID=test1.3;Name=test1.3\n")
        f.write("chr1\tquery\ttest1.4\t925\t1025\t101\t+\t.\tID=test1.4;Name=test1.4\n")
        f.write("chr1\tquery\ttest1.5\t1201\t1210\t10\t+\t.\tID=test1.5;Name=test1.5\n")
        f.write("chr1\tquery\ttest1.6\t1500\t1600\t101\t+\t.\tID=test1.6;Name=test1.6\n")
        f.close()
        
if __name__ == "__main__":
    unittest.main()