import re
import sys
from parser.mapperParser import *


class RmapParser(MapperParser):
  """A class that parses the output of Rmap format"""

  def __init__(self, fileName, verbosity = 0):
    super(RmapParser, self).__init__(fileName, verbosity)


  def __del__(self):
    super(RmapParser, self).__del__()


  def skipFirstLines(self):
    pass


  def parseLine(self, line):
    m = re.search(r"^\s*(\S+)\s+(\d+)\s+(\d+)\s+(\S+)\s+(\d+)\s+([+-])\s*$", line)
    if m == None:
      sys.exit("Line " + line + " does not have the RMAP format")

    mapping = Mapping()

    mapping.targetInterval.setChromosome(m.group(1))
    mapping.targetInterval.setStart(min(int(m.group(2)), int(m.group(3))))
    mapping.targetInterval.setEnd(max(int(m.group(2)), int(m.group(3))))

    mapping.queryInterval.setName(m.group(4))
    mapping.queryInterval.setStart(1)
    mapping.queryInterval.setSize(mapping.targetInterval.end - mapping.targetInterval.start)

    mapping.setSize(mapping.targetInterval.end - mapping.targetInterval.start)
    mapping.setNbMismatches(int(m.group(5)))
    mapping.setDirection(m.group(6))

    return mapping


