/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public class SmartInstallerTask
extends SwingWorker<Boolean, String> {
    int BUFFER = 1024;
    int architecture = 0;
    String installDirectoryName = null;
    JTextArea logArea = null;
    boolean[] selectedPrograms = null;
    String[] programChoosers = new String[]{"R", "R Color Brewer Package", "R HMisc Package", "Python 2.6", "S-MART"};
    String[][] packageAddresses = new String[][]{{"http://cran.cict.fr/bin/windows/base/R-2.11.0-win32.exe", "http://cran.cict.fr/bin/windows64/base/R-2.11.0-win64.exe"}, {"", ""}, {"", ""}, {"http://www.python.org/ftp/python/2.6.5/python-2.6.5.msi", "http://www.python.org/ftp/python/2.6.5/python-2.6.5.amd64.msi"}, {"http://urgi.versailles.inra.fr/index.php/urgi/content/download/1147/9101/file/s-mart.zip", "http://urgi.versailles.inra.fr/index.php/urgi/content/download/1147/9101/file/s-mart.zip"}};
    String[] rPackages = new String[]{"RColorBrewer", "Hmisc"};
    String[][] scriptLines = new String[][]{{"\"<INSTALLDIR>\\R-2.11.0-win32.exe\"", "\"<INSTALLDIR>\\R-2.11.0-win64.exe\""}, {"\"<RFILE>\" CMD BATCH \"<INSTALLDIR>\\installRColorBrewer.R\"", "\"<RFILE>\" CMD BATCH \"<INSTALLDIR>\\installRColorBrewer.R\""}, {"\"<RFILE>\" CMD BATCH \"<INSTALLDIR>\\installHmisc.R\"", "\"<RFILE>\" CMD BATCH \"<INSTALLDIR>\\installHmisc.R\""}, {"msiexec /i \"<INSTALLDIR>\\python-2.6.5.msi\"", "msiexec /i \"<INSTALLDIR>\\python-2.6.5.amd64.msi\""}, {"", ""}};
    String[][] compressedFiles = new String[][]{{"", ""}, {"", ""}, {"", ""}, {"", ""}, {"<INSTALLDIR>\\s-mart.zip", "<INSTALLDIR>\\s-mart.zip"}};

    public SmartInstallerTask(JTextArea jTextArea, boolean[] blArray, String string, int n) {
        this.logArea = jTextArea;
        this.selectedPrograms = blArray;
        this.installDirectoryName = string;
        this.architecture = n;
    }

    @Override
    public Boolean doInBackground() {
        this.publish("Starting install\n");
        this.writeFiles();
        for (int i = 0; i < this.selectedPrograms.length; ++i) {
            if (!this.selectedPrograms[i] || this.install(i)) continue;
            return Boolean.FALSE;
        }
        this.removeFiles();
        this.setEnvironmentVariables();
        this.publish("Ending install\n");
        return Boolean.TRUE;
    }

    @Override
    protected void process(List<String> list) {
        for (String string : list) {
            this.logArea.append(string);
        }
    }

    private boolean launch(String string) {
        return this.realLaunch(new ProcessBuilder(string), string);
    }

    private boolean launch(String[] stringArray) {
        return this.realLaunch(new ProcessBuilder(stringArray), Arrays.toString(stringArray));
    }

    private boolean realLaunch(ProcessBuilder processBuilder, String string) {
        BufferedReader bufferedReader;
        Object object;
        processBuilder = processBuilder.redirectErrorStream(true);
        Process process = null;
        this.publish("      Starting command '" + string + "'\n");
        try {
            process = processBuilder.start();
            object = new BufferedInputStream(process.getInputStream());
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        catch (Exception exception) {
            this.publish("      !Process cannot be started (command is '" + string + "')!\n");
            exception.printStackTrace();
            return false;
        }
        if (bufferedReader == null) {
            this.publish("      !Problem in the output of the command!\n");
            return false;
        }
        this.publish("      Output is:\n");
        try {
            this.publish("        ---\n");
            while ((object = bufferedReader.readLine()) != null) {
                this.publish("        " + (String)object + "\r\n");
            }
            this.publish("        ---\n");
        }
        catch (IOException iOException) {
            this.publish("      !Cannot get the output of the command!\n");
            return false;
        }
        int n = process.exitValue();
        if (n != 0) {
            this.publish("      !Problem during the execution of the command '" + string + "'!\n");
            return false;
        }
        this.publish("      Ending command '" + string + "'\n");
        return true;
    }

    private File lookForFile(String string, String[] stringArray) {
        this.publish("      Looking for file " + string + "\n");
        for (String string2 : stringArray) {
            File file = new File(string2, string);
            this.publish("      Look at " + file.getAbsolutePath() + "\n");
            if (!file.exists()) continue;
            this.publish("      Found it in expected place " + file.getAbsolutePath() + "\n");
            return file;
        }
        Stack stack = new Stack();
        stack.push(new File("\\"));
        while (!stack.empty()) {
            File file = (File)stack.pop();
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    stack.push(file2);
                    continue;
                }
                if (string.compareToIgnoreCase(file2.getName()) != 0) continue;
                this.publish("      Found it in unexpected place " + file2.getAbsolutePath() + "\n");
                return file2;
            }
        }
        this.publish("      !Cannot file file '" + string + "'!\n");
        return null;
    }

    private boolean writeFile(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            this.publish("      !Cannot write file '" + string + "'!\n");
            return false;
        }
        return true;
    }

    private boolean removeFile(String string) {
        File file = new File(string);
        if (file.exists() && !file.delete()) {
            this.publish("      !Cannot delete file '" + file.getAbsolutePath() + "'!\n");
            return false;
        }
        return true;
    }

    private boolean writeFiles() {
        String string;
        for (String string2 : this.rPackages) {
            String string3;
            String string4 = this.installDirectoryName + File.separator + "install" + string2 + ".R";
            if (this.writeFile(string4, string3 = "install.packages(\"" + string2 + "\", repos = \"http://cran.cict.fr\", dependencies = TRUE)\n")) continue;
            this.publish("    !Cannot write file for R package '" + string2 + "'!\n");
            return false;
        }
        String string5 = this.installDirectoryName + File.separator + "createUser.sql";
        if (!this.writeFile(string5, string = "CREATE USER 'smart'@'localhost';\nGRANT ALL PRIVILEGES ON *.* TO 'smart'@'localhost' WITH GRANT OPTION;\nCREATE DATABASE smart;\nGRANT ALL ON smart.* TO 'smart'@'localhost';\n")) {
            this.publish("    !Cannot write mySQL configuration file!\n");
            return false;
        }
        return true;
    }

    private boolean removeFiles() {
        for (String string : this.rPackages) {
            File file = new File(this.installDirectoryName + File.separator + "install" + string + ".R");
            if (file.delete()) continue;
            this.publish("!Cannot delete R install file for " + string + "!\n");
            return false;
        }
        File file = new File(this.installDirectoryName + File.separator + "createUser.sql");
        if (!file.delete()) {
            this.publish("!Cannot delete mySQL configuration file!\n");
            return false;
        }
        return true;
    }

    private boolean install(int n) {
        this.publish("  Starting install of " + this.programChoosers[n] + "\n");
        this.downloadPackage(n);
        this.executeInstall(n);
        this.uncompressPackage(n);
        this.removePackage(n);
        this.postProcess(n);
        this.publish("  Ending install of " + this.programChoosers[n] + "\n");
        return true;
    }

    private String getLocalName(String string) {
        String string2 = this.installDirectoryName + File.separator + new File(string).getName();
        int n = string2.indexOf("?");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private boolean downloadPackage(int n) {
        String string = this.packageAddresses[n][this.architecture];
        if (!"".equals(string)) {
            this.publish("    Starting download of " + this.programChoosers[n] + "\n");
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new URL(string).openStream());
                FileOutputStream fileOutputStream = new FileOutputStream(this.getLocalName(string));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, this.BUFFER);
                byte[] byArray = new byte[this.BUFFER];
                int n2 = 0;
                while ((n2 = bufferedInputStream.read(byArray, 0, this.BUFFER)) >= 0) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
                bufferedOutputStream.close();
                fileOutputStream.close();
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                this.publish("    !Cannot download file '" + string + "'!\n");
                return false;
            }
            this.publish("    Ending download of " + this.programChoosers[n] + "\n");
        }
        return true;
    }

    private String replaceSubstring(String string) {
        String string2;
        if (string.contains("<INSTALLDIR>")) {
            string2 = this.installDirectoryName.replaceAll("\\\\", "\\\\\\\\");
            string = string.replaceAll("<INSTALLDIR>", string2);
        }
        if (string.contains("<RFILE>")) {
            string2 = System.getenv().get("USERNAME");
            String[] stringArray = new String[]{"C:\\Program Files\\R-2.11.0", "C:\\Documents and Settings\\" + string2 + "\\Mes documents\\R\\R-2.11.0\\bin", "C:\\Documents and Settings\\" + string2 + "\\My documents\\R\\R-2.11.0\\bin"};
            String string3 = this.lookForFile("'.exe", stringArray).getAbsolutePath();
            string3 = string3.replaceAll("\\\\", "\\\\\\\\");
            string = string.replaceAll("<RFILE>", string3);
        }
        return string;
    }

    private boolean executeInstall(int n) {
        String string = this.scriptLines[n][this.architecture];
        if (!"".equals(string)) {
            for (String string2 : string.split(";")) {
                string2 = this.replaceSubstring(string2);
                this.publish("    Starting command '" + string2 + "'\n");
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec(string2);
                }
                catch (IOException iOException) {
                    this.publish("    !Cannot execute command '" + string2 + "'!\n");
                    return false;
                }
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    this.publish("    !Cannot wait for the end of the command '" + string2 + "'!\n");
                    return false;
                }
                int n2 = process.exitValue();
                if (n2 != 0) {
                    this.publish("    !Problem during the execution of the command '" + string2 + "'!\n");
                    return false;
                }
                this.publish("    Ending command '" + string2 + "'\n");
            }
        }
        return true;
    }

    private boolean uncompressPackage(int n) {
        String string = this.compressedFiles[n][this.architecture];
        if (!"".equals(string)) {
            string = this.replaceSubstring(string);
            this.publish("    Starting uncompressing file '" + string + "'\n");
            try {
                ZipEntry zipEntry;
                FileInputStream fileInputStream = new FileInputStream(string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    int n2;
                    if (zipEntry.isDirectory()) continue;
                    File file = new File(this.installDirectoryName + File.separator + zipEntry.getName());
                    for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
                        if (file2.exists()) continue;
                        file2.mkdir();
                        this.publish("      Creating directory '" + file2.getAbsolutePath() + "'\n");
                    }
                    this.publish("      Extracting '" + zipEntry.getName() + "' to '" + file.getAbsolutePath() + "'\n");
                    byte[] byArray = new byte[this.BUFFER];
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, this.BUFFER);
                    while ((n2 = zipInputStream.read(byArray, 0, this.BUFFER)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n2);
                    }
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                }
                zipInputStream.close();
                bufferedInputStream.close();
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.publish("    !Cannot find file '" + string + "'!\n");
                return false;
            }
            catch (Exception exception) {
                this.publish("    !Cannot uncompress file '" + string + "'!\n");
                return false;
            }
            this.publish("    Ending uncompressing file '" + string + "'\n");
        }
        return true;
    }

    private boolean removePackage(int n) {
        String string = this.packageAddresses[n][this.architecture];
        if ("".equals(string)) {
            return true;
        }
        String string2 = this.getLocalName(this.packageAddresses[n][this.architecture]);
        return this.removeFile(string2);
    }

    private boolean postProcess(int n) {
        switch (n) {
            case 4: {
                File file = new File(this.installDirectoryName + File.separator + "S-Mart");
                for (File file2 : file.listFiles()) {
                    File file3 = new File(file2.getParentFile().getParentFile(), file2.getName());
                    if (file2.renameTo(file3)) continue;
                    this.publish("     !Cannot move '" + file2.getAbsolutePath() + "' to '" + file3.getAbsolutePath() + "'!\n");
                }
                if (file.delete()) break;
                this.publish("     !Cannot remove installation S-MART directory '" + file.getAbsolutePath() + "'!\n");
            }
        }
        return true;
    }

    private boolean setEnvironmentVariables() {
        String[] stringArray = new String[]{"REG", "ADD", "HKCU\\Environment", "/v", "PYTHONPATH", "/t", "REG_SZ", "/d", "\"" + this.installDirectoryName + "\\Python\"", "/f"};
        return this.launch(stringArray);
    }
}

