/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.io.File;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Program {
    String shortName = null;
    String name = null;
    String section;
    String description;
    Vector<ProgramOption> options = new Vector();
    JPanel panel;
    JButton button;

    public void setShortName(String string) {
        this.shortName = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSection(String string) {
        this.section = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void addOption(ProgramOption programOption) {
        this.options.add(programOption);
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getName() {
        return this.name;
    }

    public String getSection() {
        return this.section;
    }

    public String getDescription() {
        return this.description;
    }

    public String checkValues() {
        for (int i = 0; i < this.options.size(); ++i) {
            String string = this.options.get(i).checkValue();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public LinkedList<String> getCommand() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(Global.pythonCommand);
        linkedList.add("Python" + File.separator + this.shortName);
        for (int i = 0; i < this.options.size(); ++i) {
            ProgramOption programOption = this.options.get(i);
            linkedList.addAll(programOption.getCommand());
        }
        return linkedList;
    }

    public JPanel getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel(false);
        this.panel.setLayout(new FlowLayout());
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel(false);
        JLabel jLabel = new JLabel(this.description);
        jPanel.add(jLabel);
        box.add(jPanel);
        for (int i = 0; i < this.options.size(); ++i) {
            ProgramOption programOption = this.options.get(i);
            JPanel jPanel2 = programOption.getPanel();
            if (jPanel2 == null) {
                System.out.println("Problem with Python program '" + this.shortName + "'.");
                return null;
            }
            box.add(programOption.getPanel());
        }
        JPanel jPanel3 = new JPanel(false);
        this.button = new JButton("GO!");
        jPanel3.add(this.button);
        box.add(jPanel3);
        this.panel.add(box);
        return this.panel;
    }

    public JButton getButton() {
        if (this.button == null) {
            this.getPanel();
        }
        return this.button;
    }

    public Vector<File> getOutputFiles() {
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < this.options.size(); ++i) {
            ProgramOption programOption = this.options.get(i);
            if (programOption.isInput()) continue;
            vector.add(programOption.getOutputFile());
        }
        return vector;
    }
}

