#! /usr/bin/env python
"""Start nucmer on different FASTA files"""

import glob
import os
from optparse import OptionParser
from progress import *



if __name__ == "__main__":
  
  # parse command line
  parser = OptionParser()
  parser.add_option("-i", "--input",     dest="inputFileNames",   action="store",                          type="string", help="input files")
  parser.add_option("-d", "--database",  dest="databaseName",     action="store",                          type="string", help="input files")
  parser.add_option("-v", "--verbosity", dest="verbosity",        action="store", default=1,               type="int",    help="trace level")
  parser.add_option("-l", "--log",       dest="log",              action="store", default="nucmerAll.log",                help="write a log file")
  (options, args) = parser.parse_args()

  # remove possible existing log file
  if os.path.exists(options.log):
    os.unlink(options.log)

  inputFileNames = glob.glob(options.inputFileNames + "*")
  progress = Progress(len(inputFileNames), "Handling files", options.verbosity)
  for inputFileName in inputFileNames:
    (inputBaseName, inputExtension) = os.path.splitext(inputFileName)
    cmd = "nucmer --maxmatch --mincluster=45 --nosimplify --prefix=%s --minmatch=10 %s %s > %s 2>&1 &" % (inputBaseName, options.databaseName, inputFileName, options.log)
    os.system(cmd)
    progress.inc()
  progress.done()

