"""Remove all tmp tables in the MySQL database"""

import os
import glob
from optparse import OptionParser
from mySql.mySqlConnection import *


if __name__ == "__main__":
  
  description = "Remove Tables: Remove tables in the local MySQL database. [Category: Other]"

  parser = OptionParser(description = description)
  parser.add_option("-t", "--tmp",   dest="tmp",   action="store_true",  default=False, help="Remove temporary tables only [format: bool] [default: false]")
  parser.add_option("-f", "--files", dest="files", action="store_false", default=True,  help="Do not remove temporary files [format: bool] [default: true]")
  (options, args) = parser.parse_args()
  
  mySqlConnection  = MySqlConnection(100)
  mySqlQuerySelect = mySqlConnection.executeQuery("SHOW TABLES")
  for line in mySqlQuerySelect.getIterator():
    table = line[0]
    if table.startswith("tmp") or not options.tmp:
      mySqlQueryRemove = mySqlConnection.executeQuery("DROP table %s" % (table))
      print "Removing '%s'" % (table)

  print "Removing temporary files:"
  if options.files:
    for tmpFile in glob.glob("tmp*.dat"):
      print "  removing %s" % (tmpFile)
      os.unlink(tmpFile)

