import unittest, os
from commons.core.parsing.BedParser import BedParser


class Test_BedParser(unittest.TestCase):
    
    def test_Parser(self):
        parser = BedParser("data/testBedParser1.bed")

        self.assertEqual(parser.getNbTranscripts(), 1)

        for transcript in parser.getIterator():
            self.assertEqual(transcript.getChromosome(), "arm_X")
            self.assertEqual(transcript.getName(), "test1.1")
            self.assertEqual(transcript.getStart(), 1000)
            self.assertEqual(transcript.getEnd(), 2999)
            self.assertEqual(transcript.getDirection(), 1)
            self.assertEqual(transcript.getNbExons(), 2)
            exons = transcript.getExons()
            self.assertEqual(exons[0].getChromosome(), "arm_X")
            self.assertEqual(exons[0].getStart(), 1000)
            self.assertEqual(exons[0].getEnd(), 1099)
            self.assertEqual(exons[0].getDirection(), 1)
            self.assertEqual(exons[1].getChromosome(), "arm_X")
            self.assertEqual(exons[1].getStart(), 2000)
            self.assertEqual(exons[1].getEnd(), 2999)
            self.assertEqual(exons[1].getDirection(), 1)

    def test_Parser_short(self):
        tmpFileName = "tmpFile.bed"
        tmpHandle   = open(tmpFileName, "w")
        tmpHandle.write("""X\t554748\t554904\texon
X\t554748\t554904\tCDS
X\t554748\t554750\tstart_codon
""")
        tmpHandle.close()
        parser = BedParser(tmpFileName)
        self.assertEqual(parser.getNbTranscripts(), 3)
        for cpt, transcript in enumerate(parser.getIterator()):
            self.assertEqual(transcript.getNbExons(), 1)
            self.assertEqual(transcript.getChromosome(), "X")
            self.assertEqual(transcript.getStart(), 554748)
            if cpt == 0:
                self.assertEqual(transcript.getEnd(), 554903)
                self.assertEqual(transcript.getName(), "exon")
            elif cpt == 1:
                self.assertEqual(transcript.getEnd(), 554903)
                self.assertEqual(transcript.getName(), "CDS")
            elif cpt == 2:
                self.assertEqual(transcript.getEnd(), 554749)
                self.assertEqual(transcript.getName(), "start_codon")
        os.remove(tmpFileName)



if __name__ == '__main__':
        unittest.main()

