from commons.core.utils.FileUtils import FileUtils
from commons.core.parsing.WigParser import WigParser
import glob
import unittest
import os

class Test_WigParser(unittest.TestCase):
    
    def tearDown(self):
        for file in glob.glob("data/.chr*.index"):
              os.remove(file)

    def test_GetRange1(self):
        self.parser = WigParser("data/test.wig")
        outputRange = [0.0, 1.1, 1.2, 0.0, 1.4, 1.5, 0.0, 1.7, 0.0, 1.9, 0.0]
        self.assertEqual(self.parser.getRange("chr1", 10, 20), outputRange)
        outputRange = [0.0, 9.5, 9.6, 0.0]
        self.assertEqual(self.parser.getRange("chrX", 4, 7), outputRange)

    def test_GetRange2(self):
        self.parser = WigParser("data/test1.wig")
        outputRange = [0.0, 1.1, 1.2, 0.0, 1.4, 1.5, 0.0, 1.7, 0.0, 1.9, 0.0]
        self.assertEqual(self.parser.getRange("chr2", 10, 20), outputRange)

    def test_GetRange3(self):
        self.parser = WigParser("data/test2.wig")
        outputRange = [1.4, 1.5]
        self.assertEqual(self.parser.getRange("chr3", 14, 15), outputRange)

if __name__ == '__main__':
        unittest.main()
