#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import re
import sys
from SMART.Java.Python.structure.Mapping import Mapping
from commons.core.parsing.MapperParser import MapperParser
from SMART.Java.Python.structure.SubMapping import SubMapping
from SMART.Java.Python.misc import Utils
from SMART.Java.Python.structure.Transcript import Transcript
from commons.core.parsing.TranscriptListParser import TranscriptListParser


class MapParser(TranscriptListParser):
    """A class that parses the repet .map files"""

    def __init__(self, fileName, verbosity = 0):
        self._lineParseRe = re.compile(r"(?P<seqName>\w+)\s(?P<chrName>\w+)\s(?P<sStart>\d+)\s(?P<sEnd>\d+)")
        TranscriptListParser.__init__(self, fileName, verbosity)

    def getFileFormats():
        return ["map"]
    getFileFormats = staticmethod(getFileFormats)

    def skipFirstLines(self):    
        return
        
    def parseLine(self, line):
        m = self._lineParseRe.search(line)
        
        if m == None:
            sys.exit("\nLine %d '%s' does not have a map format" % (self.currentLineNb, line))
            
        transcript = Transcript()
        transcript.setChromosome(m.group("chrName"))
        transcript.setStart(min(int(m.group("sStart")), int(m.group("sEnd"))))
        transcript.setEnd(max(int(m.group("sStart")), int(m.group("sEnd"))))
        transcript.setName(m.group("seqName"))
        transcript.setDirection(1)

        return transcript
