#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#

class SequenceListWriter(object):
    """
    An interface that writes a list of sequences into a file
    @ivar fileName: name of the file 
    @type fileName: string
    @ivar handle: handle to the file
    @type handle: file handle
    @ivar header: first lines of the file
    @type header: string
    """


    def __init__(self, fileName, verbosity = 0):
        """
        Constructor
        @param fileName: name of the file 
        @type fileName: string
        @param verbosity: verbosity
        @type verbosity: int
        """
        self.fileName = fileName
        self.verbosity = verbosity
        self.handle = open(self.fileName, "w")


    def __del__(self):
        """
        Destructor
        """
        self.close()
        

    def write(self):
        """
        No-op
        """
        pass
        
        
    def close(self):
        """
        Close writer
        """
        if self.handle != None:
            self.handle.close()
        
        
    def addSequence(self, sequence):
        """
        Add a sequence to the list of sequence to be written
        @param sequence: sequence to be written
        @type    sequence: class L{Sequence<Sequence>}
        """
        self.handle.write(self.getLine(sequence))


    def addElement(self, element):
        """
        Same as "addSequence"
        @param element: sequence to be written
        @type    element: class L{Sequence<Sequence>}
        """
        self.addSequence(element)

