#
# Copyright INRA-URGI 2009-2010
# 
# This software is governed by the CeCILL license under French law and
# abiding by the rules of distribution of free software. You can use,
# modify and/ or redistribute the software under the terms of the CeCILL
# license as circulated by CEA, CNRS and INRIA at the following URL
# "http://www.cecill.info".
# 
# As a counterpart to the access to the source code and rights to copy,
# modify and redistribute granted by the license, users are provided only
# with a limited warranty and the software's author, the holder of the
# economic rights, and the successive licensors have only limited
# liability.
# 
# In this respect, the user's attention is drawn to the risks associated
# with loading, using, modifying and/or developing or reproducing the
# software by the user in light of its specific status of free software,
# that may mean that it is complicated to manipulate, and that also
# therefore means that it is reserved for developers and experienced
# professionals having in-depth computer knowledge. Users are therefore
# encouraged to load and test the software's suitability as regards their
# requirements in conditions enabling the security of their systems and/or
# data to be ensured and, more generally, to use and operate it in the
# same conditions as regards security.
# 
# The fact that you are presently reading this means that you have had
# knowledge of the CeCILL license and that you accept its terms.
#
import re
import sys
from SMART.Java.Python.structure.Mapping import Mapping
from commons.core.parsing.MapperParser import MapperParser


class ShrimpParser(MapperParser):
    """A class that parses the output of Shrimp"""

    def __init__(self, fileName, verbosity = 0):
        super(ShrimpParser, self).__init__(fileName, verbosity)


    def __del__(self):
        super(ShrimpParser, self).__del__()


    def getFileFormats():
        return ["shrimp"]
    getFileFormats = staticmethod(getFileFormats)


    def skipFirstLines(self):
        self.handle.readline()
        self.currentLineNb += 1


    def parseLine(self, line):
        m = re.search(r"^\s*>([^\t]+)\t+(\S+)\s+([+-])\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\S+)\s*$", line)
        if m == None:
            sys.exit("\nLine %d '%s' does not have a Shrimp format" % (self.currentLineNb, line))

        mapping = Mapping()

        mapping.queryInterval.setName(m.group(1))
        mapping.queryInterval.setStart(min(int(m.group(6)), int(m.group(7))))
        mapping.queryInterval.setEnd(max(int(m.group(6)), int(m.group(7))))

        mapping.targetInterval.setChromosome(m.group(2))
        mapping.targetInterval.setStart(min(int(m.group(4)), int(m.group(5))))
        mapping.targetInterval.setEnd(max(int(m.group(4)), int(m.group(5))))

        mapping.setSize(int(m.group(8)))
        mapping.setDirection(m.group(3))

        editString = m.group(10)
        nbMismatches = 0
        nbGaps = 0
        while editString != "":
            m = re.search(r"^(\d+)(\D.*)$", editString)
            if m != None:
                editString = m.group(2)
            else:
                m = re.search(r"^(\d+)$", editString)
                if m != None:
                    editString = ""
                else:
                    m = re.search(r"^([A-Z])(.*)$", editString)
                    if m != None:
                        nbMismatches += 1
                        editString = m.group(2)
                    else:
                        m = re.search(r"^\((\w+)\)(.*)$", editString)
                        if m != None:
                            nbGaps += len(m.group(1))
                            editString = m.group(2)
                        else:
                            m = re.search(r"^-(.*)$", editString)
                            if m != None:
                                nbGaps += 1
                                editString = m.group(1)
                            else:
                                sys.exit("Cannot understand edit string %s from line %s" % (editString, line))

        mapping.setNbMismatches(nbMismatches)
        mapping.setNbGaps(nbGaps)

        return mapping
